/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.controller;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jlxxw.component.weixin.component.EventBus;
import net.jlxxw.component.weixin.properties.WeiXinProperties;
import net.jlxxw.component.weixin.security.WeiXinServerSecurityCheck;
import net.jlxxw.component.weixin.util.NetworkUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"weixin"})
@ConditionalOnProperty(value={"weixin.netty.server.enable-netty"}, havingValue="false")
public class WeiXinMessageController {
    @Autowired
    private EventBus eventBus;
    @Autowired(required=false)
    private WeiXinServerSecurityCheck weiXinServerSecurityCheck;
    @Autowired
    private WeiXinProperties weiXinProperties;

    @RequestMapping(value={"core"})
    public void coreController(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ipAddress;
        if (this.weiXinProperties.isEnableWeiXinCallBackServerSecurityCheck() && this.weiXinServerSecurityCheck != null && !this.weiXinServerSecurityCheck.isSecurity(ipAddress = NetworkUtil.getIpAddress(request))) {
            return;
        }
        String result = this.eventBus.dispatcher(request);
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
        writer.close();
    }
}

