/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.component.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import net.jlxxw.component.weixin.component.EventBus;
import net.jlxxw.component.weixin.properties.WeiXinProperties;
import net.jlxxw.component.weixin.security.WeiXinServerSecurityCheck;
import net.jlxxw.component.weixin.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class WeiXinChannel
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(WeiXinChannel.class);
    @Autowired
    private EventBus eventBus;
    @Autowired(required=false)
    private WeiXinServerSecurityCheck weiXinServerSecurityCheck;
    @Autowired
    private WeiXinProperties weiXinProperties;

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) throws Exception {
        LoggerUtils.debug(logger, "netty \u5f00\u59cb\u5904\u7406", new Object[0]);
        if (this.weiXinProperties.isEnableWeiXinCallBackServerSecurityCheck() && this.weiXinServerSecurityCheck != null) {
            InetSocketAddress socketAddress = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
            String ipAddress = socketAddress.getAddress().getHostAddress();
            LoggerUtils.debug(logger, "\u5fae\u4fe1\u56de\u8c03ip\u5b89\u5168\u68c0\u67e5\u6267\u884c,\u8fdc\u7a0bip:{}", ipAddress);
            if (!this.weiXinServerSecurityCheck.isSecurity(ipAddress)) {
                LoggerUtils.warn(logger, "\u975e\u6cd5ip\uff0c\u4e0d\u4e88\u5904\u7406:{}", ipAddress);
                channelHandlerContext.writeAndFlush((Object)this.responseOK(HttpResponseStatus.FORBIDDEN, Unpooled.copiedBuffer((CharSequence)"IP FORBIDDEN", (Charset)CharsetUtil.UTF_8))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
        }
        ByteBuf content = fullHttpRequest.content();
        byte[] reqContent = new byte[content.readableBytes()];
        content.readBytes(reqContent);
        String uri = fullHttpRequest.uri();
        String resultData = this.eventBus.dispatcher(reqContent, uri);
        ByteBuf responseData = Unpooled.copiedBuffer((CharSequence)resultData, (Charset)CharsetUtil.UTF_8);
        FullHttpResponse response = this.responseOK(HttpResponseStatus.OK, responseData);
        channelHandlerContext.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private FullHttpResponse responseOK(HttpResponseStatus status, ByteBuf content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        if (content != null) {
            response.headers().set("Content-Type", (Object)"application/xml;charset=UTF-8");
            response.headers().set("Content_Length", (Object)response.content().readableBytes());
        }
        return response;
    }
}

