/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.jlxxw.component.weixin.component.WeiXinMsgCodec;
import net.jlxxw.component.weixin.component.listener.AbrstractWeiXinEventListener;
import net.jlxxw.component.weixin.component.listener.AbrstractWeiXinMessageListener;
import net.jlxxw.component.weixin.component.listener.UnKnowWeiXinEventListener;
import net.jlxxw.component.weixin.component.listener.UnKnowWeiXinMessageListener;
import net.jlxxw.component.weixin.dto.message.AbrstractWeiXinMessage;
import net.jlxxw.component.weixin.dto.message.ImageMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.LinkMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.LocationMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.ShortVideoMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.TextMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.VideoMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.VoiceMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.ClickMenuGetInfoEventMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.ClickMenuGotoLinkEventMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.LocationEventMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.SubscribeEventMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.SubscribeQrsceneEventMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.SubscribeScanEventMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.TemplateEventMessageAbrstract;
import net.jlxxw.component.weixin.dto.message.event.UnSubscribeEventMessageAbrstract;
import net.jlxxw.component.weixin.enums.WeiXinEventTypeEnum;
import net.jlxxw.component.weixin.enums.WeiXinMessageTypeEnum;
import net.jlxxw.component.weixin.exception.AesException;
import net.jlxxw.component.weixin.properties.WeiXinProperties;
import net.jlxxw.component.weixin.response.WeiXinMessageResponse;
import net.jlxxw.component.weixin.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventBus {
    private static final Logger logger = LoggerFactory.getLogger(EventBus.class);
    @Autowired(required=false)
    private List<AbrstractWeiXinMessageListener> abrstractWeiXinMessageListeners;
    @Autowired(required=false)
    private List<AbrstractWeiXinEventListener> abrstractWeiXinEventListeners;
    @Autowired(required=false)
    private WeiXinMsgCodec weiXinMsgCodec;
    @Autowired
    private WeiXinProperties weiXinProperties;
    @Autowired(required=false)
    private UnKnowWeiXinEventListener unKnowWeiXinEventListener;
    @Autowired(required=false)
    private UnKnowWeiXinMessageListener unKnowWeiXinMessageListener;
    @Autowired
    private ThreadPoolTaskExecutor eventBusThreadPool;
    private final XmlMapper xmlMapper = new XmlMapper();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<WeiXinMessageTypeEnum, AbrstractWeiXinMessageListener> messageListenerMap = new HashMap<WeiXinMessageTypeEnum, AbrstractWeiXinMessageListener>();
    private final Map<WeiXinEventTypeEnum, AbrstractWeiXinEventListener> eventListenerMap = new HashMap<WeiXinEventTypeEnum, AbrstractWeiXinEventListener>();

    @PostConstruct
    public void postConstruct() {
        WeiXinEventTypeEnum[] eventValues;
        WeiXinMessageTypeEnum[] values;
        this.xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.xmlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        if (!CollectionUtils.isEmpty(this.abrstractWeiXinMessageListeners)) {
            Map<WeiXinMessageTypeEnum, List<AbrstractWeiXinMessageListener>> map = this.abrstractWeiXinMessageListeners.stream().collect(Collectors.groupingBy(AbrstractWeiXinMessageListener::supportMessageType));
            map.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BeanCreationException("\u5fae\u4fe1messageListener\u4e0d\u80fd\u6ce8\u518c\u591a\u6b21");
                }
                this.messageListenerMap.put((WeiXinMessageTypeEnum)((Object)k), (AbrstractWeiXinMessageListener)v.get(0));
            });
        }
        for (WeiXinMessageTypeEnum value : values = WeiXinMessageTypeEnum.values()) {
            if (this.messageListenerMap.containsKey((Object)value)) continue;
            LoggerUtils.warn(logger, value.getDescription() + "\u6d88\u606f\u5904\u7406\u5668\u672a\u6ce8\u518c!!!", new Object[0]);
        }
        if (!CollectionUtils.isEmpty(this.abrstractWeiXinEventListeners)) {
            Map<WeiXinEventTypeEnum, List<AbrstractWeiXinEventListener>> eventMap = this.abrstractWeiXinEventListeners.stream().collect(Collectors.groupingBy(AbrstractWeiXinEventListener::supportEventType));
            eventMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BeanCreationException("\u5fae\u4fe1eventListener\u4e0d\u80fd\u6ce8\u518c\u591a\u6b21");
                }
                this.eventListenerMap.put((WeiXinEventTypeEnum)((Object)k), (AbrstractWeiXinEventListener)v.get(0));
            });
        }
        for (WeiXinEventTypeEnum value : eventValues = WeiXinEventTypeEnum.values()) {
            if (this.eventListenerMap.containsKey((Object)value)) continue;
            LoggerUtils.warn(logger, value.getDescription() + "\u4e8b\u4ef6\u5904\u7406\u5668\u672a\u6ce8\u518c!!!", new Object[0]);
        }
    }

    public String dispatcher(HttpServletRequest request) {
        Future future = this.eventBusThreadPool.submit(() -> {
            ServletInputStream inputStream = request.getInputStream();
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
            return this.handlerWeiXinMessage(reader);
        });
        try {
            return (String)future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Enumeration parameterNames = request.getParameterNames();
            JSONObject jsonObject = new JSONObject();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                jsonObject.put(name, (Object)request.getParameter(name));
            }
            logger.error("\u4e8b\u4ef6\u5206\u53d1\u5904\u7406\u51fa\u73b0\u5f02\u5e38,\u5fae\u4fe1\u53c2\u6570:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)jsonObject.toJSONString(), (Object)e);
            return "";
        }
    }

    public String dispatcher(byte[] bytes, String uri) throws AesException {
        if (this.weiXinProperties.isEnableMessageEnc()) {
            String[] split;
            String inputXML = new String(bytes, StandardCharsets.UTF_8);
            HashMap<String, String> map = new HashMap<String, String>(16);
            int index = uri.indexOf("?");
            String str = uri.substring(index + 1);
            for (String s : split = str.split("&")) {
                String[] arr = s.split("=");
                map.put(arr[0], arr[1]);
            }
            String msgSignature = (String)map.get("msg_signature");
            String timestamp = (String)map.get("timestamp");
            String nonce = (String)map.get("nonce");
            String decryptMsg = this.weiXinMsgCodec.decryptMsg(msgSignature, timestamp, nonce, inputXML);
            LoggerUtils.debug(logger, "\u5fae\u4fe1\u6d88\u606f\u89e3\u5bc6\u6210\u529f\uff0c\u4fe1\u606f\u4e3a:{}", decryptMsg);
            bytes = decryptMsg.getBytes(StandardCharsets.UTF_8);
        }
        String result = this.dispatcher(bytes);
        if (this.weiXinProperties.isEnableMessageEnc()) {
            result = this.weiXinMsgCodec.encrypt(result);
            LoggerUtils.debug(logger, "\u5fae\u4fe1\u6d88\u606f\u52a0\u5bc6\u6210\u529f\uff0c\u4fe1\u606f\u4e3a:{}", result);
        }
        return result;
    }

    public String dispatcher(byte[] bytes) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            InputStreamReader reader = new InputStreamReader(inputStream);
            return this.handlerWeiXinMessage(reader);
        }
        catch (Exception e) {
            logger.error("\u4e8b\u4ef6\u5206\u53d1\u5904\u7406\u51fa\u73b0\u5f02\u5e38,\u5fae\u4fe1\u53c2\u6570:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)new String(bytes, StandardCharsets.UTF_8), (Object)e);
            return "";
        }
    }

    private String handlerWeiXinMessage(Reader reader) throws IOException {
        String msgType;
        ObjectNode objectNode = (ObjectNode)this.xmlMapper.readValue(reader, ObjectNode.class);
        switch (msgType = objectNode.get("MsgType").textValue()) {
            case "text": {
                AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), TextMessageAbrstract.class);
                return this.handlerMessage(abrstractWeiXinMessage, WeiXinMessageTypeEnum.TEXT);
            }
            case "image": {
                AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), ImageMessageAbrstract.class);
                return this.handlerMessage(abrstractWeiXinMessage, WeiXinMessageTypeEnum.IMAGE);
            }
            case "voice": {
                AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), VoiceMessageAbrstract.class);
                return this.handlerMessage(abrstractWeiXinMessage, WeiXinMessageTypeEnum.VOICE);
            }
            case "video": {
                AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), VideoMessageAbrstract.class);
                return this.handlerMessage(abrstractWeiXinMessage, WeiXinMessageTypeEnum.VIDEO);
            }
            case "shortvideo": {
                AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), ShortVideoMessageAbrstract.class);
                return this.handlerMessage(abrstractWeiXinMessage, WeiXinMessageTypeEnum.SHORT_VIDEO);
            }
            case "location": {
                AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), LocationMessageAbrstract.class);
                return this.handlerMessage(abrstractWeiXinMessage, WeiXinMessageTypeEnum.LOCATION);
            }
            case "link": {
                AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), LinkMessageAbrstract.class);
                return this.handlerMessage(abrstractWeiXinMessage, WeiXinMessageTypeEnum.LINK);
            }
            case "event": {
                String event;
                switch (event = objectNode.get("Event").textValue()) {
                    case "subscribe": {
                        if (Objects.isNull(objectNode.get("EventKey"))) {
                            AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), SubscribeEventMessageAbrstract.class);
                            return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.SUBSCRIBE);
                        }
                        String eventKey = objectNode.get("EventKey").textValue();
                        if (eventKey != null && eventKey.contains("qrscene_")) {
                            AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), SubscribeQrsceneEventMessageAbrstract.class);
                            return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.SUBSCRIBE_QRSCENE);
                        }
                        AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), SubscribeEventMessageAbrstract.class);
                        return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.SUBSCRIBE);
                    }
                    case "unsubscribe": {
                        AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), UnSubscribeEventMessageAbrstract.class);
                        return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.UNSUBSCRIBE);
                    }
                    case "SCAN": {
                        AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), SubscribeScanEventMessageAbrstract.class);
                        return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.SCAN);
                    }
                    case "LOCATION": {
                        AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), LocationEventMessageAbrstract.class);
                        return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.LOCATION);
                    }
                    case "CLICK": {
                        AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), ClickMenuGetInfoEventMessageAbrstract.class);
                        return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.CLICK);
                    }
                    case "TEMPLATESENDJOBFINISH": {
                        AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), TemplateEventMessageAbrstract.class);
                        return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.TEMPLATESENDJOBFINISH);
                    }
                    case "VIEW": {
                        AbrstractWeiXinMessage abrstractWeiXinMessage = (AbrstractWeiXinMessage)this.objectMapper.readValue(objectNode.toString(), ClickMenuGotoLinkEventMessageAbrstract.class);
                        return this.handlerEvent(abrstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                }
                if (Objects.isNull(this.unKnowWeiXinEventListener)) {
                    throw new IllegalArgumentException("\u672a\u77e5\u7684\u4e8b\u4ef6\u8bf7\u6c42\u4fe1\u606f\u7c7b\u578b\uff0cevent:" + event + ",\u8bf7\u6c42\u6570\u636e\u4fe1\u606f:" + objectNode.toString());
                }
                return this.unKnowWeiXinEventListener.handlerOtherType(objectNode);
            }
        }
        if (Objects.isNull(this.unKnowWeiXinMessageListener)) {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6d88\u606f\u8bf7\u6c42\u4fe1\u606f\u7c7b\u578b,messageType:" + msgType + ",\u8bf7\u6c42\u6570\u636e\u4fe1\u606f:" + objectNode.toString());
        }
        return this.unKnowWeiXinMessageListener.handlerOtherType(objectNode);
    }

    private String handlerMessage(AbrstractWeiXinMessage abrstractWeiXinMessage, WeiXinMessageTypeEnum weiXinMessageTypeEnum) {
        if (CollectionUtils.isEmpty(this.abrstractWeiXinMessageListeners)) {
            throw new IllegalArgumentException("\u672a\u6ce8\u518c\u4efb\u4f55\u76f8\u5173\u6d88\u606f\u76d1\u542c\u5668\uff0c\u6216\u76d1\u542c\u5668\u672a\u52a0\u5165\u5230ioc\u5bb9\u5668\u4e2d");
        }
        AbrstractWeiXinMessageListener abrstractWeiXinMessageListener = this.messageListenerMap.get((Object)weiXinMessageTypeEnum);
        if (Objects.isNull(abrstractWeiXinMessageListener)) {
            throw new IllegalArgumentException(weiXinMessageTypeEnum.name() + "\u6d88\u606f\u76d1\u542c\u5668\u672a\u6ce8\u518c");
        }
        LoggerUtils.debug(logger, "\u63a5\u6536\u5230\u5fae\u4fe1\u8bf7\u6c42\uff0c\u8bf7\u6c42\u7c7b\u578b:{},\u8bf7\u6c42\u53c2\u6570:{}", weiXinMessageTypeEnum.getDescription(), JSON.toJSONString((Object)abrstractWeiXinMessage));
        WeiXinMessageResponse response = abrstractWeiXinMessageListener.handler(abrstractWeiXinMessage);
        if (Objects.isNull(response)) {
            return "";
        }
        String toUserName = abrstractWeiXinMessage.getToUserName();
        String fromUserName = abrstractWeiXinMessage.getFromUserName();
        response.setFromUserName(toUserName);
        response.setCreateTime(System.currentTimeMillis() / 1000L);
        response.setToUserName(fromUserName);
        try {
            String res = this.xmlMapper.writeValueAsString((Object)response);
            LoggerUtils.debug(logger, "\u8fd4\u56de\u5fae\u4fe1\u5e94\u7b54\u4fe1\u606f\uff0c\u53c2\u6570:{}", res);
            return res;
        }
        catch (JsonProcessingException e) {
            LoggerUtils.error(logger, "jackson \u8f6cxml\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570:" + JSON.toJSONString((Object)response), e);
            return "";
        }
    }

    private String handlerEvent(AbrstractWeiXinMessage abrstractWeiXinMessage, WeiXinEventTypeEnum weiXinEventTypeEnum) {
        if (CollectionUtils.isEmpty(this.abrstractWeiXinEventListeners)) {
            throw new IllegalArgumentException("\u672a\u6ce8\u518c\u76f8\u5173\u4e8b\u4ef6\u76d1\u542c\u5668\uff0c\u6216\u76d1\u542c\u5668\u672a\u52a0\u5165\u5230ioc\u5bb9\u5668\u4e2d");
        }
        AbrstractWeiXinEventListener abrstractWeiXinEventListener = this.eventListenerMap.get((Object)weiXinEventTypeEnum);
        if (Objects.isNull(abrstractWeiXinEventListener)) {
            throw new IllegalArgumentException(weiXinEventTypeEnum.name() + "\u4e8b\u4ef6\u76d1\u542c\u5668\u672a\u6ce8\u518c");
        }
        WeiXinMessageResponse response = abrstractWeiXinEventListener.handler(abrstractWeiXinMessage);
        if (Objects.isNull(response)) {
            return "";
        }
        String toUserName = abrstractWeiXinMessage.getToUserName();
        String fromUserName = abrstractWeiXinMessage.getFromUserName();
        response.setFromUserName(toUserName);
        response.setCreateTime(System.currentTimeMillis() / 1000L);
        response.setToUserName(fromUserName);
        try {
            return this.xmlMapper.writeValueAsString((Object)response);
        }
        catch (JsonProcessingException e) {
            LoggerUtils.error(logger, "jackson \u8f6cxml\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570:" + JSON.toJSONString((Object)response), e);
            return "";
        }
    }
}

