/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.security;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import net.jlxxw.wechat.event.netty.WeChatEventNettyAutoConfiguration;
import net.jlxxw.wechat.event.netty.handler.SecurityHandler;
import net.jlxxw.wechat.repository.ip.IpSegmentRepository;
import net.jlxxw.wechat.security.blacklist.BlackList;
import net.jlxxw.wechat.security.properties.WeChatSecurityProperties;
import net.jlxxw.wechat.security.repository.BlackListRepository;
import net.jlxxw.wechat.security.repository.EmbeddedIpSegmentRepository;
import net.jlxxw.wechat.security.template.SecurityFilterTemplate;
import net.jlxxw.wechat.web.filter.WeChatSecurityFilter;
import net.jlxxw.wechat.web.properties.WeChatEventWebProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"wechat.security.enable"}, havingValue="true")
@ComponentScan(value={"net.jlxxw.wechat.security"})
public class WeChatSecurityAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={IpSegmentRepository.class})
    public IpSegmentRepository ipSegmentRepository() {
        return new EmbeddedIpSegmentRepository();
    }

    @Bean
    @ConditionalOnBean(value={WeChatEventNettyAutoConfiguration.class})
    public SecurityHandler securityHandler(IpSegmentRepository ipSegmentRepository, BlackList blackList) {
        return new SecurityHandler(ipSegmentRepository, blackList);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlackList.class})
    public BlackList blackList(WeChatSecurityProperties weChatSecurityProperties) {
        return new BlackListRepository(weChatSecurityProperties.getBlackList());
    }

    @Bean
    @ConditionalOnClass(value={HttpServletRequest.class})
    public SecurityFilterTemplate weChatSecurityFilter(BlackList blackList, IpSegmentRepository ipSegmentRepository) {
        return new WeChatSecurityFilter(blackList, ipSegmentRepository);
    }

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<WeChatSecurityFilter> weChatSecutityFilterRegistrationBean(SecurityFilterTemplate weChatSecurityFilter, WeChatEventWebProperties weChatEventWebProperties) {
        String coreControllerUrl = weChatEventWebProperties.getCoreControllerUrl();
        FilterRegistrationBean registration = new FilterRegistrationBean();
        WeChatSecurityFilter filter = (WeChatSecurityFilter)weChatSecurityFilter;
        registration.setFilter((Filter)filter);
        if (coreControllerUrl.startsWith("/")) {
            registration.addUrlPatterns(new String[]{coreControllerUrl});
        } else {
            registration.addUrlPatterns(new String[]{"/" + coreControllerUrl});
        }
        registration.setOrder(-1);
        return registration;
    }
}

