/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.repository.mysql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import net.jlxxw.wechat.repository.aibot.WeChatAiBotTokenRepository;
import net.jlxxw.wechat.repository.jsapi.WeChatJsApiTicketRepository;
import net.jlxxw.wechat.repository.mysql.properties.WeChatMySqlProperties;
import net.jlxxw.wechat.repository.token.WeChatTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ComponentScan(value={"net.jlxxw.wechat.repository.mysql"})
public class WeChatRepositoryMySqlAutoConfiguration
implements ApplicationRunner,
BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(WeChatRepositoryMySqlAutoConfiguration.class);
    @Autowired
    private WeChatMySqlProperties weChatMysqlProperties;
    private DataSource dataSource;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void run(ApplicationArguments args) throws Exception {
        String sql;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.beanFactory;
        CharSequence dataSourceBeanName = this.weChatMysqlProperties.getDataSourceBeanName();
        CharSequence[] beanNames = defaultListableBeanFactory.getBeanNamesForType(DataSource.class);
        if (beanNames.length == 0) {
            throw new BeanCreationException("\u672a\u80fd\u53d1\u73b0\u6570\u636e\u6e90");
        }
        logger.info("\u53d1\u73b0\u6570\u636e\u6e90:{}", (Object)String.join((CharSequence)",", beanNames));
        if (beanNames.length > 1) {
            for (CharSequence beanName : beanNames) {
                if (!((String)beanName).equals(dataSourceBeanName)) continue;
                dataSourceBeanName = beanName;
                break;
            }
        }
        this.dataSource = (DataSource)defaultListableBeanFactory.getBean(dataSourceBeanName, DataSource.class);
        logger.info("\u4f7f\u7528\u6570\u636e\u6e90:{}", (Object)dataSourceBeanName);
        if (this.weChatMysqlProperties.isEnableAutoCreateJsApiTable()) {
            sql = this.load("sql/wechat_js_api_ticket_table.sql");
            Connection connection = this.dataSource.getConnection();
            Statement statement = connection.createStatement();
            statement.execute(sql);
            statement.close();
            connection.close();
            logger.info("\u5df2\u81ea\u52a8\u521b\u5efa wechat_js_api_ticket \u8868");
        }
        if (this.weChatMysqlProperties.isEnableAutoCreateTokenTable()) {
            sql = this.load("sql/wechat_token_table.sql");
            Connection connection = this.dataSource.getConnection();
            Statement statement = connection.createStatement();
            statement.execute(sql);
            statement.close();
            connection.close();
            logger.info("\u5df2\u81ea\u52a8\u521b\u5efa wechat_token \u8868");
        }
    }

    @Bean
    public WeChatTokenRepository weChatTokenRepository() {
        return new WeChatTokenRepository(){
            private static final String insertSQL = "INSERT INTO wechat_token (`token`) values(?)";
            private static final String selectSQL = "SELECT `token` FROM wechat_token order by id desc limit 1";

            public void save(String token) {
                Connection connection = null;
                Statement preparedStatement = null;
                try {
                    connection = WeChatRepositoryMySqlAutoConfiguration.this.dataSource.getConnection();
                    connection.setAutoCommit(true);
                    preparedStatement = connection.prepareStatement(insertSQL);
                    preparedStatement.setString(1, token);
                    preparedStatement.execute();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public String get() {
                try (Connection connection = WeChatRepositoryMySqlAutoConfiguration.this.dataSource.getConnection();){
                    String string;
                    block15: {
                        PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
                        try {
                            ResultSet resultSet = preparedStatement.executeQuery();
                            boolean next = resultSet.next();
                            if (!next) {
                                throw new IllegalStateException("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728 token");
                            }
                            string = resultSet.getString(1);
                            if (preparedStatement == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return string;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Bean
    public WeChatJsApiTicketRepository weChatJsApiTicketRepository() {
        return new WeChatJsApiTicketRepository(){
            private static final String insertSQL = "INSERT INTO wechat_js_api_ticket (`ticket`) values(?)";
            private static final String selectSQL = "SELECT `ticket` FROM wechat_js_api_ticket order by id desc limit 1";

            public void save(String jsApiTicket) {
                Connection connection = null;
                Statement preparedStatement = null;
                try {
                    connection = WeChatRepositoryMySqlAutoConfiguration.this.dataSource.getConnection();
                    connection.setAutoCommit(true);
                    preparedStatement = connection.prepareStatement(insertSQL);
                    preparedStatement.setString(1, jsApiTicket);
                    preparedStatement.execute();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public String get() {
                try (Connection connection = WeChatRepositoryMySqlAutoConfiguration.this.dataSource.getConnection();){
                    String string;
                    block15: {
                        PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);
                        try {
                            ResultSet resultSet = preparedStatement.executeQuery();
                            boolean next = resultSet.next();
                            if (!next) {
                                throw new IllegalStateException("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728 ticket");
                            }
                            string = resultSet.getString(1);
                            if (preparedStatement == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return string;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={WeChatAiBotTokenRepository.class})
    public WeChatAiBotTokenRepository weChatAiBotTokenRepository() {
        return () -> null;
    }

    private String load(String path) throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(path);
        InputStream inputStream = classPathResource.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        ArrayList<String> lines = new ArrayList<String>();
        String line = bufferedReader.readLine();
        while (line != null) {
            lines.add(line);
            line = bufferedReader.readLine();
        }
        return String.join((CharSequence)"", lines);
    }
}

