/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function;

import net.jlxxw.wechat.aop.ParamCheckAOP;
import net.jlxxw.wechat.function.ai.AiBotFunction;
import net.jlxxw.wechat.function.api.OpenApiManager;
import net.jlxxw.wechat.function.auth.WebPageAuthorizationManager;
import net.jlxxw.wechat.function.ip.IpManager;
import net.jlxxw.wechat.function.material.MaterialManager;
import net.jlxxw.wechat.function.material.PermanentMaterialManager;
import net.jlxxw.wechat.function.material.TempMaterialManager;
import net.jlxxw.wechat.function.menu.MenuManager;
import net.jlxxw.wechat.function.menu.PersonalizedMenuManager;
import net.jlxxw.wechat.function.properties.WeChatAiBotProperties;
import net.jlxxw.wechat.function.push.SyncPushCustomer;
import net.jlxxw.wechat.function.push.SyncPushTemplate;
import net.jlxxw.wechat.function.qrcode.QrcodeManager;
import net.jlxxw.wechat.function.tag.TagManager;
import net.jlxxw.wechat.function.token.TokenManager;
import net.jlxxw.wechat.function.user.UserManager;
import net.jlxxw.wechat.log.util.LoggerUtils;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.repository.aibot.WeChatAiBotTokenRepository;
import net.jlxxw.wechat.repository.token.WeChatTokenRepository;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@ComponentScan(value={"net.jlxxw.wechat.function"})
public class WeChatFunctionAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WeChatFunctionAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate() {
        int defaultMaxPerRoute = 200;
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(2 * defaultMaxPerRoute);
        connectionManager.setDefaultMaxPerRoute(defaultMaxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().build();
        CloseableHttpClient build = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)build));
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316 RestTemplate", (Object[])new Object[0]);
        return restTemplate;
    }

    @Bean
    public ParamCheckAOP paramCheckAOP() {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316 \u51fd\u6570\u53c2\u6570\u68c0\u67e5\u5207\u9762", (Object[])new Object[0]);
        return new ParamCheckAOP();
    }

    @Bean
    @ConditionalOnBean(value={WeChatAiBotProperties.class})
    public AiBotFunction aiBotFunction(RestTemplate restTemplate, WeChatAiBotTokenRepository weChatAiBotTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 aiBotFunction", (Object[])new Object[0]);
        return new AiBotFunction(restTemplate, weChatAiBotTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatProperties.class, WeChatTokenRepository.class})
    public OpenApiManager openApiManager(RestTemplate restTemplate, WeChatProperties weChatProperties, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 OpenApiManager", (Object[])new Object[0]);
        return new OpenApiManager(weChatProperties, weChatTokenRepository, restTemplate);
    }

    @Bean
    @ConditionalOnBean(value={WeChatProperties.class})
    public WebPageAuthorizationManager webPageAuthorizationManager(RestTemplate restTemplate, WeChatProperties weChatProperties) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 WebPageAuthorizationManager", (Object[])new Object[0]);
        return new WebPageAuthorizationManager(restTemplate, weChatProperties);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public MaterialManager materialManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 MaterialManager", (Object[])new Object[0]);
        return new MaterialManager(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public PermanentMaterialManager permanentMaterialManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 PermanentMaterialManager", (Object[])new Object[0]);
        return new PermanentMaterialManager(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public TempMaterialManager tempMaterialManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 TempMaterialManager", (Object[])new Object[0]);
        return new TempMaterialManager(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public MenuManager menuManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 MenuManager", (Object[])new Object[0]);
        return new MenuManager(weChatTokenRepository, restTemplate);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public PersonalizedMenuManager personalizedMenuManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 PersonalizedMenuManager", (Object[])new Object[0]);
        return new PersonalizedMenuManager(weChatTokenRepository, restTemplate);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public SyncPushCustomer syncPushCustomer(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 SyncPushCustomer", (Object[])new Object[0]);
        return new SyncPushCustomer(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public SyncPushTemplate syncPushTemplate(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 SyncPushTemplate", (Object[])new Object[0]);
        return new SyncPushTemplate(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public QrcodeManager qrcodeManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 QrcodeManager", (Object[])new Object[0]);
        return new QrcodeManager(weChatTokenRepository, restTemplate);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public TagManager tagManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 TagManager", (Object[])new Object[0]);
        return new TagManager(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatProperties.class})
    public TokenManager tokenManager(RestTemplate restTemplate, WeChatProperties weChatProperties) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 TokenManager", (Object[])new Object[0]);
        return new TokenManager(restTemplate, weChatProperties);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public UserManager userManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 UserManager", (Object[])new Object[0]);
        return new UserManager(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatTokenRepository.class})
    public IpManager ipManager(RestTemplate restTemplate, WeChatTokenRepository weChatTokenRepository) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u521d\u59cb\u5316\u51fd\u6570 IpManager", (Object[])new Object[0]);
        return new IpManager(restTemplate, weChatTokenRepository);
    }

    @Bean
    @ConditionalOnBean(value={WeChatAiBotProperties.class})
    public WeChatAiBotTokenRepository weChatAiBotTokenRepository(WeChatAiBotProperties weChatAiBotProperties) {
        return weChatAiBotProperties::getToken;
    }
}

