/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.web;

import java.util.List;
import net.jlxxw.wechat.event.codec.WeChatCiphertextWeChatMessageCodec;
import net.jlxxw.wechat.event.codec.WeChatMessageCodec;
import net.jlxxw.wechat.event.codec.WeChatPlaintextWeChatMessageCodec;
import net.jlxxw.wechat.event.component.EventBus;
import net.jlxxw.wechat.event.component.listener.AbstractWeChatEventListener;
import net.jlxxw.wechat.event.component.listener.AbstractWeChatMessageListener;
import net.jlxxw.wechat.event.component.listener.UnKnowWeChatEventListener;
import net.jlxxw.wechat.event.component.listener.UnKnowWeChatMessageListener;
import net.jlxxw.wechat.exception.AesException;
import net.jlxxw.wechat.log.util.LoggerUtils;
import net.jlxxw.wechat.properties.WeChatProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"net.jlxxw.wechat.web", "net.jlxxw.wechat.event", "net.jlxxw.wechat.properties"})
public class WeChatEventWebAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WeChatEventWebAutoConfiguration.class);

    @Bean
    public EventBus eventBus(@Autowired(required=false) List<AbstractWeChatMessageListener> abstractWeChatMessageListeners, @Autowired(required=false) List<AbstractWeChatEventListener> abstractWeChatEventListeners, @Autowired(required=false) UnKnowWeChatEventListener unKnowWeChatEventListener, @Autowired(required=false) UnKnowWeChatMessageListener unKnowWeChatMessageListener, WeChatMessageCodec weChatMessageCodec) {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u4e8b\u4ef6\u603b\u7ebf \u52a0\u8f7d\u5b8c\u6bd5", (Object[])new Object[0]);
        return new EventBus(null, abstractWeChatMessageListeners, abstractWeChatEventListeners, unKnowWeChatEventListener, unKnowWeChatMessageListener, weChatMessageCodec);
    }

    @Bean
    @ConditionalOnProperty(value={"wechat.event.server.web.codec"}, havingValue="CIPHER_TEXT")
    public WeChatMessageCodec weChatCiphertextMessageCodec(WeChatProperties weChatProperties) throws AesException {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u7f16\u89e3\u7801\u5668\u5bc6\u6587\u6a21\u5f0f \u52a0\u8f7d\u5b8c\u6bd5", (Object[])new Object[0]);
        return new WeChatCiphertextWeChatMessageCodec(weChatProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public WeChatMessageCodec weChatPlaintextMessageCodec() {
        LoggerUtils.info((Logger)logger, (String)"\u516c\u4f17\u53f7\u7ec4\u4ef6 ---> \u7f16\u89e3\u7801\u5668\u660e\u6587\u6a21\u5f0f \u52a0\u8f7d\u5b8c\u6bd5", (Object[])new Object[0]);
        return new WeChatPlaintextWeChatMessageCodec();
    }
}

