/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.schema.org;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import net.jlxxw.schema.org.JsonLdType;

public class JsonLdTypeDeserializer
extends JsonDeserializer<JsonLdType> {
    public JsonLdType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            return new JsonLdType(node.asText());
        }
        if (node.isArray()) {
            ArrayList<String> types = new ArrayList<String>();
            for (JsonNode n : node) {
                types.add(n.asText());
            }
            return new JsonLdType(types);
        }
        return null;
    }
}

