package net.jlxxw.schema.org;


import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;


public class Service extends Intangible {
    {
        setId("schema:Service");
        setType("rdfs:Class");

    }

    /**
     * Certification information about a product, organization, service, place, or person.
     */
    @JsonProperty("hasCertification")
    private Certification hasCertification;
    /**
     * The overall rating, based on a collection of reviews or ratings, of the item.
     */
    @JsonProperty("aggregateRating")
    private AbstractSchema aggregateRating;
    /**
     * An award won by or for this item.
     */
    @JsonProperty("award")
    private String award;
    /**
     * A pointer to another, somehow related product (or multiple products).
     */
    @JsonProperty("isRelatedTo")
    private List<AbstractSchema> isRelatedTo;
    /**
     * The hours during which this service or contact is available.
     */
    @JsonProperty("hoursAvailable")
    private AbstractSchema hoursAvailable;
    /**
     * An offer to provide this item&#x2014;for example, an offer to sell a product, rent the DVD of a movie, perform a service, or give away tickets to an event. Use [[businessFunction]] to indicate the kind of transaction offered, i.e. sell, lease, etc. This property can also be used to describe a [[Demand]]. While this property is listed as expected on a number of common types, it can be used in others. In that case, using a second type, such as Product or a subtype of Product, can clarify the nature of the offer.
     */
    @JsonProperty("offers")
    private List<AbstractSchema> offers;
    /**
     * The brand(s) associated with a product or service, or the brand(s) maintained by an organization or business person.
     */
    @JsonProperty("brand")
    private List<Organization> brand;
    /**
     * The geographic area where a service or offered item is provided.
     */
    @JsonProperty("areaServed")
    private String areaServed;
    /**
     * The geographic area where the service is provided.
     */
    @JsonProperty("serviceArea")
    private List<AbstractSchema> serviceArea;
    /**
     * The tangible thing generated by the service, e.g. a passport, permit, etc.
     */
    @JsonProperty("produces")
    private Thing produces;
    /**
     * The tangible thing generated by the service, e.g. a passport, permit, etc.
     */
    @JsonProperty("serviceOutput")
    private Thing serviceOutput;
    /**
     * Human-readable terms of service documentation.
     */
    @JsonProperty("termsOfService")
    private String termsOfService;
    /**
     * A category for the item. Greater signs or slashes can be used to informally indicate a category hierarchy.
     */
    @JsonProperty("category")
    private String category;
    /**
     * Indicates an OfferCatalog listing for this Organization, Person, or Service.
     */
    @JsonProperty("hasOfferCatalog")
    private OfferCatalog hasOfferCatalog;
    /**
     * The service provider, service operator, or service performer; the goods producer. Another party (a seller) may offer those services or goods on behalf of the provider. A provider may also serve as the seller.
     */
    @JsonProperty("provider")
    private List<AbstractSchema> provider;
    /**
     * A means of accessing the service (e.g. a phone bank, a web site, a location, etc.).
     */
    @JsonProperty("availableChannel")
    private ServiceChannel availableChannel;
    /**
     * An associated logo.
     */
    @JsonProperty("logo")
    private String logo;
    /**
     * The type of service being offered, e.g. veterans' benefits, emergency relief, etc.
     */
    @JsonProperty("serviceType")
    private String serviceType;
    /**
     * The audience eligible for this service.
     */
    @JsonProperty("serviceAudience")
    private Audience serviceAudience;
    /**
     * A slogan or motto associated with the item.
     */
    @JsonProperty("slogan")
    private String slogan;
    /**
     * A review of the item.
     */
    @JsonProperty("review")
    private AbstractSchema review;
    /**
     * Indicates the mobility of a provided service (e.g. 'static', 'dynamic').
     */
    @JsonProperty("providerMobility")
    private String providerMobility;
    /**
     * A pointer to another, functionally similar product (or multiple products).
     */
    @JsonProperty("isSimilarTo")
    private List<AbstractSchema> isSimilarTo;
    /**
     * An entity that arranges for an exchange between a buyer and a seller.  In most cases a broker never acquires or releases ownership of a product or service involved in an exchange.  If it is not clear whether an entity is a broker, seller, or buyer, the latter two terms are preferred.
     */
    @JsonProperty("broker")
    private List<AbstractSchema> broker;

    public Certification getHasCertification() {
        return hasCertification;
    }

    public void setHasCertification(Certification hasCertification) {
        this.hasCertification = hasCertification;
    }

    public AbstractSchema getAggregateRating() {
        return aggregateRating;
    }

    public void setAggregateRating(AbstractSchema aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    public String getAward() {
        return award;
    }

    public void setAward(String award) {
        this.award = award;
    }

    public List<AbstractSchema> getIsRelatedTo() {
        return isRelatedTo;
    }

    public void setIsRelatedTo(List<AbstractSchema> isRelatedTo) {
        this.isRelatedTo = isRelatedTo;
    }

    public AbstractSchema getHoursAvailable() {
        return hoursAvailable;
    }

    public void setHoursAvailable(AbstractSchema hoursAvailable) {
        this.hoursAvailable = hoursAvailable;
    }

    public List<AbstractSchema> getOffers() {
        return offers;
    }

    public void setOffers(List<AbstractSchema> offers) {
        this.offers = offers;
    }

    public List<Organization> getBrand() {
        return brand;
    }

    public void setBrand(List<Organization> brand) {
        this.brand = brand;
    }

    public String getAreaServed() {
        return areaServed;
    }

    public void setAreaServed(String areaServed) {
        this.areaServed = areaServed;
    }

    public List<AbstractSchema> getServiceArea() {
        return serviceArea;
    }

    public void setServiceArea(List<AbstractSchema> serviceArea) {
        this.serviceArea = serviceArea;
    }

    public Thing getProduces() {
        return produces;
    }

    public void setProduces(Thing produces) {
        this.produces = produces;
    }

    public Thing getServiceOutput() {
        return serviceOutput;
    }

    public void setServiceOutput(Thing serviceOutput) {
        this.serviceOutput = serviceOutput;
    }

    public String getTermsOfService() {
        return termsOfService;
    }

    public void setTermsOfService(String termsOfService) {
        this.termsOfService = termsOfService;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public OfferCatalog getHasOfferCatalog() {
        return hasOfferCatalog;
    }

    public void setHasOfferCatalog(OfferCatalog hasOfferCatalog) {
        this.hasOfferCatalog = hasOfferCatalog;
    }

    public List<AbstractSchema> getProvider() {
        return provider;
    }

    public void setProvider(List<AbstractSchema> provider) {
        this.provider = provider;
    }

    public ServiceChannel getAvailableChannel() {
        return availableChannel;
    }

    public void setAvailableChannel(ServiceChannel availableChannel) {
        this.availableChannel = availableChannel;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getServiceType() {
        return serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Audience getServiceAudience() {
        return serviceAudience;
    }

    public void setServiceAudience(Audience serviceAudience) {
        this.serviceAudience = serviceAudience;
    }

    public String getSlogan() {
        return slogan;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    public AbstractSchema getReview() {
        return review;
    }

    public void setReview(AbstractSchema review) {
        this.review = review;
    }

    public String getProviderMobility() {
        return providerMobility;
    }

    public void setProviderMobility(String providerMobility) {
        this.providerMobility = providerMobility;
    }

    public List<AbstractSchema> getIsSimilarTo() {
        return isSimilarTo;
    }

    public void setIsSimilarTo(List<AbstractSchema> isSimilarTo) {
        this.isSimilarTo = isSimilarTo;
    }

    public List<AbstractSchema> getBroker() {
        return broker;
    }

    public void setBroker(List<AbstractSchema> broker) {
        this.broker = broker;
    }
}