package net.jlxxw.schema.org;


import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;


public class MovieSeries extends CreativeWorkSeries {
    {
        setId("schema:MovieSeries");
        setType("rdfs:Class");

    }

    /**
     * The production company or studio responsible for the item, e.g. series, video game, episode etc.
     */
    @JsonProperty("productionCompany")
    private Organization productionCompany;
    /**
     * The composer of the soundtrack.
     */
    @JsonProperty("musicBy")
    private List<AbstractSchema> musicBy;
    /**
     * A director of e.g. TV, radio, movie, video gaming etc. content, or of an event. Directors can be associated with individual items or with a series, episode, clip.
     */
    @JsonProperty("director")
    private Person director;
    /**
     * An actor (individual or a group), e.g. in TV, radio, movie, video games etc., or in an event. Actors can be associated with individual items or with a series, episode, clip.
     */
    @JsonProperty("actor")
    private List<AbstractSchema> actor;
    /**
     * The trailer of a movie or TV/radio series, season, episode, etc.
     */
    @JsonProperty("trailer")
    private VideoObject trailer;
    /**
     * An actor, e.g. in TV, radio, movie, video games etc. Actors can be associated with individual items or with a series, episode, clip.
     */
    @JsonProperty("actors")
    private Person actors;
    /**
     * A director of e.g. TV, radio, movie, video games etc. content. Directors can be associated with individual items or with a series, episode, clip.
     */
    @JsonProperty("directors")
    private Person directors;

    public Organization getProductionCompany() {
        return productionCompany;
    }

    public void setProductionCompany(Organization productionCompany) {
        this.productionCompany = productionCompany;
    }

    public List<AbstractSchema> getMusicBy() {
        return musicBy;
    }

    public void setMusicBy(List<AbstractSchema> musicBy) {
        this.musicBy = musicBy;
    }

    public Person getDirector() {
        return director;
    }

    public void setDirector(Person director) {
        this.director = director;
    }

    public List<AbstractSchema> getActor() {
        return actor;
    }

    public void setActor(List<AbstractSchema> actor) {
        this.actor = actor;
    }

    public VideoObject getTrailer() {
        return trailer;
    }

    public void setTrailer(VideoObject trailer) {
        this.trailer = trailer;
    }

    public Person getActors() {
        return actors;
    }

    public void setActors(Person actors) {
        this.actors = actors;
    }

    public Person getDirectors() {
        return directors;
    }

    public void setDirectors(Person directors) {
        this.directors = directors;
    }
}