/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.serializer;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.jemzart.jsonkraken.JsonArray;
import net.jemzart.jsonkraken.JsonObject;
import net.jemzart.jsonkraken.JsonValue;
import net.jemzart.jsonkraken.serializer.Serializer;
import net.jemzart.jsonkraken.serializer.Tabulation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0019\u0010\u001c\u001a\u00020\u0010*\u00060\u001dj\u0002`\u001e2\u0006\u0010\u0002\u001a\u00020\bH\u0082\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/jemzart/jsonkraken/serializer/TemplateSerializer;", "Lnet/jemzart/jsonkraken/serializer/Serializer;", "value", "Lnet/jemzart/jsonkraken/JsonValue;", "tabulation", "Lnet/jemzart/jsonkraken/serializer/Tabulation;", "(Lnet/jemzart/jsonkraken/JsonValue;Lnet/jemzart/jsonkraken/serializer/Tabulation;)V", "indentation", "", "nesting", "", "tabs", "getTabs", "()Ljava/lang/String;", "create", "writeArray", "", "arr", "Lnet/jemzart/jsonkraken/JsonArray;", "writeDelimiter", "writeEnd", "it", "writeKey", "writeObject", "obj", "Lnet/jemzart/jsonkraken/JsonObject;", "writeStart", "writeTabs", "plusAssign", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "jsonkraken"})
public final class TemplateSerializer
extends Serializer {
    private final String indentation;
    private int nesting;
    private final JsonValue value;

    private final void plusAssign(@NotNull StringBuilder $this$plusAssign, String value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$plusAssign, (String)"$this$plusAssign");
        $this$plusAssign.append(value);
    }

    private final String getTabs() {
        return StringsKt.repeat((CharSequence)this.indentation, (int)this.nesting);
    }

    private final void writeKey(String it) {
        this.plusAssign(this.getStb(), '\"' + it + "\": ");
    }

    private final void writeStart(String it) {
        this.plusAssign(this.getStb(), it + '\n');
        TemplateSerializer templateSerializer = this;
        ++templateSerializer.nesting;
        int cfr_ignored_0 = templateSerializer.nesting;
    }

    private final void writeEnd(String it) {
        this.plusAssign(this.getStb(), "\n");
        TemplateSerializer templateSerializer = this;
        templateSerializer.nesting += -1;
        int cfr_ignored_0 = templateSerializer.nesting;
        this.plusAssign(this.getStb(), this.getTabs() + it);
    }

    private final void writeDelimiter() {
        this.plusAssign(this.getStb(), ",\n" + this.getTabs());
    }

    private final void writeTabs() {
        this.plusAssign(this.getStb(), this.getTabs());
    }

    @NotNull
    public final String create() {
        this.writeValue(this.value);
        String string = this.getStb().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stb.toString()");
        return string;
    }

    @Override
    public void writeObject(@NotNull JsonObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        this.writeStart("{");
        boolean first = true;
        for (Map.Entry<String, JsonValue> pair : obj) {
            if (first) {
                this.writeTabs();
                first = false;
            } else {
                this.writeDelimiter();
            }
            this.writeKey(pair.getKey());
            this.writeValue(pair.getValue());
        }
        this.writeEnd("}");
    }

    @Override
    public void writeArray(@NotNull JsonArray arr) {
        Intrinsics.checkParameterIsNotNull((Object)arr, (String)"arr");
        this.writeStart("[");
        boolean first = true;
        for (JsonValue item : arr) {
            if (first) {
                this.writeTabs();
                first = false;
            } else {
                this.writeDelimiter();
            }
            this.writeValue(item);
        }
        this.writeEnd("]");
    }

    public TemplateSerializer(@NotNull JsonValue value, @NotNull Tabulation tabulation) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)((Object)tabulation), (String)"tabulation");
        this.value = value;
        this.indentation = tabulation.getValue();
    }
}

