/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.helpers;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.jemzart.jsonkraken.constants.Escapable;
import net.jemzart.jsonkraken.errors.primitives.NonCompliantStringException;
import net.jemzart.jsonkraken.helpers.CharHelperKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0010"}, d2={"throwIfEscapingNonEscapableCharacter", "", "string", "", "i", "", "throwIfISOControlCharacterOtherThanDelete", "throwIfIsNotAJsonCompliantString", "throwIfIsUnescapedBackslash", "throwIfNonHexadecimalValueInsideUnicode", "throwIfUnescapedDoubleQuotes", "throwIfUnescapedWhiteSpaceCharacter", "throwIfUnicodeIsTooShort", "throwNonCompliantString", "", "message", "jsonkraken"})
public final class JsonStringHelperKt {
    public static final void throwIfIsNotAJsonCompliantString(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                JsonStringHelperKt.throwIfIsUnescapedBackslash(string, ++i);
                if (string.charAt(i) == 'u') {
                    JsonStringHelperKt.throwIfUnicodeIsTooShort(string, i);
                    JsonStringHelperKt.throwIfNonHexadecimalValueInsideUnicode(string, ++i);
                    JsonStringHelperKt.throwIfNonHexadecimalValueInsideUnicode(string, ++i);
                    JsonStringHelperKt.throwIfNonHexadecimalValueInsideUnicode(string, ++i);
                    JsonStringHelperKt.throwIfNonHexadecimalValueInsideUnicode(string, ++i);
                    continue;
                }
                JsonStringHelperKt.throwIfEscapingNonEscapableCharacter(string, i);
                continue;
            }
            JsonStringHelperKt.throwIfUnescapedDoubleQuotes(string, i);
            JsonStringHelperKt.throwIfUnescapedWhiteSpaceCharacter(string, i);
            JsonStringHelperKt.throwIfISOControlCharacterOtherThanDelete(string, i);
        }
    }

    private static final void throwIfISOControlCharacterOtherThanDelete(String string, int i) {
        if (CharHelperKt.isISOControlCharacterOtherThanDelete(string.charAt(i))) {
            Void void_ = JsonStringHelperKt.throwNonCompliantString("Unescaped iso control character at index " + i, string);
            throw null;
        }
    }

    private static final void throwIfUnescapedWhiteSpaceCharacter(String string, int i) {
        if (ArraysKt.contains((Object[])Escapable.INSTANCE.getWhiteSpaceChars(), (Object)Character.valueOf(string.charAt(i)))) {
            Void void_ = JsonStringHelperKt.throwNonCompliantString("Unescaped white space character at index " + i, string);
            throw null;
        }
    }

    private static final void throwIfUnescapedDoubleQuotes(String string, int i) {
        if (string.charAt(i) == '\"') {
            Void void_ = JsonStringHelperKt.throwNonCompliantString("Unescaped \" at index " + i, string);
            throw null;
        }
    }

    private static final void throwIfEscapingNonEscapableCharacter(String string, int i) {
        if (!ArraysKt.contains((Object[])Escapable.INSTANCE.getMonoChars(), (Object)Character.valueOf(string.charAt(i)))) {
            Void void_ = JsonStringHelperKt.throwNonCompliantString("Unescapable character '" + string.charAt(i) + "' found at index " + i, string);
            throw null;
        }
    }

    private static final void throwIfNonHexadecimalValueInsideUnicode(String string, int i) {
        if (CharHelperKt.isNotHexadecimal(string.charAt(i))) {
            Void void_ = JsonStringHelperKt.throwNonCompliantString("Invalid hexadecimal character '" + string.charAt(i) + "' at index " + i, string);
            throw null;
        }
    }

    private static final void throwIfIsUnescapedBackslash(String string, int i) {
        if (i >= string.length()) {
            Void void_ = JsonStringHelperKt.throwNonCompliantString("Unescaped \\ at end of string", string);
            throw null;
        }
    }

    private static final void throwIfUnicodeIsTooShort(String string, int i) {
        if (i + 4 >= string.length()) {
            Void void_ = JsonStringHelperKt.throwNonCompliantString("Expected four hexadecimal characters but found end of string", string);
            throw null;
        }
    }

    private static final Void throwNonCompliantString(String message, String string) {
        throw (Throwable)new NonCompliantStringException(string, message);
    }
}

