/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.helpers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.jemzart.jsonkraken.errors.primitives.NonCompliantNumberException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"regex", "Lkotlin/text/Regex;", "cleanIfNegativeZero", "", "integer", "simplifyJsonNumber", "number", "throwIfIsNotAJsonCompliantNumber", "", "jsonkraken"})
public final class JsonNumberHelperKt {
    private static final Regex regex = new Regex("-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?");

    public static final void throwIfIsNotAJsonCompliantNumber(@NotNull String number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        if (!regex.matches((CharSequence)number)) {
            throw (Throwable)new NonCompliantNumberException(number);
        }
    }

    @NotNull
    public static final String simplifyJsonNumber(@NotNull String number) {
        boolean bl;
        String integer;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
            int indexOfDot = StringsKt.indexOf$default((CharSequence)number, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (indexOfDot == -1) {
                return JsonNumberHelperKt.cleanIfNegativeZero(number);
            }
            String string = number;
            int n = 0;
            int n2 = 0;
            String string2 = string.substring(n, indexOfDot);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            integer = string2;
            String string3 = number;
            n2 = indexOfDot + 1;
            boolean bl2 = false;
            String string4 = string3.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String decimal = string4;
            CharSequence $this$all$iv = decimal;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl3 = false;
                if (it == '0') continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            return JsonNumberHelperKt.cleanIfNegativeZero(integer);
        }
        return number;
    }

    private static final String cleanIfNegativeZero(String integer) {
        return Intrinsics.areEqual((Object)integer, (Object)"-0") ? "0" : integer;
    }
}

