/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.helpers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.jemzart.jsonkraken.JsonArray;
import net.jemzart.jsonkraken.JsonContainer;
import net.jemzart.jsonkraken.JsonObject;
import net.jemzart.jsonkraken.JsonValue;
import net.jemzart.jsonkraken.errors.collections.CircularReferenceException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"isReferencedBy", "", "Lnet/jemzart/jsonkraken/JsonContainer;", "value", "", "", "references", "throwIfHasAReferenceOnMe", "", "target", "Lnet/jemzart/jsonkraken/JsonValue;", "jsonkraken"})
public final class JsonContainerHelperKt {
    public static final boolean isReferencedBy(@NotNull JsonContainer $this$isReferencedBy, @NotNull Iterable<? extends Object> value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isReferencedBy, (String)"$this$isReferencedBy");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        for (Object object : value) {
            if (Intrinsics.areEqual((Object)object, (Object)$this$isReferencedBy)) {
                return true;
            }
            if (!(object instanceof JsonContainer) || !JsonContainerHelperKt.references((JsonContainer)object, $this$isReferencedBy)) continue;
            return true;
        }
        return false;
    }

    public static final void throwIfHasAReferenceOnMe(@NotNull JsonContainer $this$throwIfHasAReferenceOnMe, @NotNull JsonValue target) {
        Intrinsics.checkParameterIsNotNull((Object)$this$throwIfHasAReferenceOnMe, (String)"$this$throwIfHasAReferenceOnMe");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (target instanceof JsonContainer) {
            if (Intrinsics.areEqual((Object)target, (Object)$this$throwIfHasAReferenceOnMe)) {
                throw (Throwable)new CircularReferenceException($this$throwIfHasAReferenceOnMe, (JsonContainer)target);
            }
            if (JsonContainerHelperKt.references((JsonContainer)target, $this$throwIfHasAReferenceOnMe)) {
                throw (Throwable)new CircularReferenceException($this$throwIfHasAReferenceOnMe, (JsonContainer)target);
            }
        }
    }

    public static final boolean references(@NotNull JsonContainer $this$references, @NotNull JsonContainer value) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$references, (String)"$this$references");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonContainer jsonContainer = $this$references;
        if (jsonContainer instanceof JsonArray) {
            bl = JsonContainerHelperKt.isReferencedBy(value, (Iterable<? extends Object>)((JsonArray)$this$references).getList());
        } else if (jsonContainer instanceof JsonObject) {
            bl = JsonContainerHelperKt.isReferencedBy(value, (Iterable<? extends Object>)((JsonObject)$this$references).getHashMap$jsonkraken().values());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

