/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.deserializer.deserializers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.jemzart.jsonkraken.JsonValue;
import net.jemzart.jsonkraken.deserializer.Deserializer;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeArrayKt;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeFalseKt;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeNullKt;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeNumberKt;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeObjectKt;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeStringKt;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeTrueKt;
import net.jemzart.jsonkraken.deserializer.throws.ThrowErrorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0003"}, d2={"deserializeValue", "Lnet/jemzart/jsonkraken/JsonValue;", "Lnet/jemzart/jsonkraken/deserializer/Deserializer;", "jsonkraken"})
public final class DeserializeValueKt {
    @NotNull
    public static final JsonValue deserializeValue(@NotNull Deserializer $this$deserializeValue) {
        JsonValue jsonValue;
        Intrinsics.checkParameterIsNotNull((Object)$this$deserializeValue, (String)"$this$deserializeValue");
        char c = $this$deserializeValue.peek();
        if (c == '{') {
            jsonValue = DeserializeObjectKt.deserializeObject($this$deserializeValue);
        } else if (c == '[') {
            jsonValue = DeserializeArrayKt.deserializeArray($this$deserializeValue);
        } else if (c == '\"') {
            jsonValue = DeserializeStringKt.deserializeString($this$deserializeValue);
        } else if (c == 't') {
            jsonValue = DeserializeTrueKt.deserializeTrue($this$deserializeValue);
        } else if (c == 'f') {
            jsonValue = DeserializeFalseKt.deserializeFalse($this$deserializeValue);
        } else if (c == 'n') {
            jsonValue = DeserializeNullKt.deserializeNull($this$deserializeValue);
        } else if (c == '-') {
            jsonValue = DeserializeNumberKt.deserializeNumberLowerThanZero($this$deserializeValue);
        } else if (c == '0') {
            jsonValue = DeserializeNumberKt.deserializeNumberStartingWithZero($this$deserializeValue);
        } else {
            char c2 = c;
            if ('1' <= c2 && '9' >= c2) {
                jsonValue = DeserializeNumberKt.deserializeNumberEqualOrHigherThanOne($this$deserializeValue);
            } else {
                Void void_ = ThrowErrorKt.throwError($this$deserializeValue, "No JSON token starts with '" + c + "'.");
                throw null;
            }
        }
        return jsonValue;
    }
}

