/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.deserializer;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jemzart.jsonkraken.JsonValue;
import net.jemzart.jsonkraken.deserializer.deserializers.DeserializeValueKt;
import net.jemzart.jsonkraken.deserializer.throws.ThrowErrorKt;
import net.jemzart.jsonkraken.deserializer.validators.ValidateEOFKt;
import net.jemzart.jsonkraken.deserializer.validators.ValidateEqualityKt;
import net.jemzart.jsonkraken.deserializer.validators.ValidateIsNotEndOfStringKt;
import net.jemzart.jsonkraken.helpers.CharHelperKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0001J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0010R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lnet/jemzart/jsonkraken/deserializer/Deserializer;", "", "raw", "", "(Ljava/lang/String;)V", "<set-?>", "", "index", "getIndex", "()I", "last", "getLast", "getRaw", "()Ljava/lang/String;", "advance", "consume", "", "char", "", "create", "Lnet/jemzart/jsonkraken/JsonValue;", "current", "isAtEnd", "", "match", "next", "peek", "skipWhiteSpaces", "Companion", "jsonkraken"})
@PublishedApi
public final class Deserializer {
    private final int last;
    private int index;
    @NotNull
    private final String raw;
    @NotNull
    public static final String BLANK_RAW_STRING = "Blank text is not a valid JSON representation.";
    public static final Companion Companion = new Companion(null);

    public final int getLast() {
        return this.last;
    }

    public final int getIndex() {
        return this.index;
    }

    @PublishedApi
    @NotNull
    public final JsonValue create() {
        this.skipWhiteSpaces();
        if (this.isAtEnd()) {
            Void void_ = ThrowErrorKt.throwError(this, BLANK_RAW_STRING);
            throw null;
        }
        JsonValue result = DeserializeValueKt.deserializeValue(this);
        this.skipWhiteSpaces();
        ValidateEOFKt.validateEOF(this);
        return result;
    }

    public final boolean isAtEnd() {
        return this.index == this.last;
    }

    public final char current() {
        return this.raw.charAt(this.index);
    }

    public final int advance() {
        int n = this.index;
        this.index = n + 1;
        return n;
    }

    public final char peek() {
        ValidateIsNotEndOfStringKt.validateIsNotEndOfString(this);
        return this.raw.charAt(this.index);
    }

    public final char next() {
        ValidateIsNotEndOfStringKt.validateIsNotEndOfString(this);
        int n = this.index;
        this.index = n + 1;
        return this.raw.charAt(n);
    }

    public final void consume(char c) {
        ValidateEqualityKt.validateEquality(this, this.next(), c);
    }

    public final boolean match(char c) {
        boolean result;
        ValidateIsNotEndOfStringKt.validateIsNotEndOfString(this);
        boolean bl = result = this.raw.charAt(this.index) == c;
        if (result) {
            int n = this.index;
            this.index = n + 1;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final void skipWhiteSpaces() {
        int n = this.index;
        int n2 = this.last;
        while (n < n2) {
            void i;
            if (!CharHelperKt.isWhiteSpace(this.raw.charAt((int)i))) {
                this.index = i;
                return;
            }
            ++i;
        }
        this.index = this.last;
    }

    @NotNull
    public final String getRaw() {
        return this.raw;
    }

    public Deserializer(@NotNull String raw) {
        Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
        this.raw = raw;
        this.last = this.raw.length();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/jemzart/jsonkraken/deserializer/Deserializer$Companion;", "", "()V", "BLANK_RAW_STRING", "", "jsonkraken"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

