/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import net.jemzart.jsonkraken.JsonContainer;
import net.jemzart.jsonkraken.JsonKraken;
import net.jemzart.jsonkraken.JsonValue;
import net.jemzart.jsonkraken.errors.collections.NoSuchPropertyException;
import net.jemzart.jsonkraken.errors.transformation.UnexpectedJsonValueException;
import net.jemzart.jsonkraken.helpers.JsonContainerHelperKt;
import net.jemzart.jsonkraken.helpers.JsonStringHelperKt;
import net.jemzart.jsonkraken.helpers.JsonValueHelperKt;
import net.jemzart.jsonkraken.purifier.PurifierKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\u0010'\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0002B7\b\u0016\u0012.\u0010\u0006\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0007\"\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nB\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u0000H\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004J\u0011\u0010 \u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0004H\u0096\u0002J\b\u0010!\u001a\u00020\u001eH\u0016J\u001b\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050$0#H\u0096\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u0004J\u001b\u0010'\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\tH\u0096\u0002R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lnet/jemzart/jsonkraken/JsonObject;", "Lnet/jemzart/jsonkraken/JsonContainer;", "", "", "", "Lnet/jemzart/jsonkraken/JsonValue;", "properties", "", "Lkotlin/Pair;", "", "([Lkotlin/Pair;)V", "()V", "hashMap", "", "getHashMap$jsonkraken", "()Ljava/util/Map;", "keys", "", "getKeys", "()Ljava/util/Set;", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "clone", "containsKey", "", "key", "get", "isEmpty", "iterator", "", "", "remove", "", "set", "value", "jsonkraken"})
public final class JsonObject
extends JsonContainer
implements Iterable<Map.Entry<? extends String, ? extends JsonValue>>,
KMappedMarker {
    @NotNull
    private final Map<String, JsonValue> hashMap;

    @NotNull
    public final Map<String, JsonValue> getHashMap$jsonkraken() {
        return this.hashMap;
    }

    @Override
    @NotNull
    public JsonValue get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        JsonValue jsonValue = this.hashMap.get(key);
        if (jsonValue == null) {
            throw (Throwable)new NoSuchPropertyException(key, this);
        }
        return jsonValue;
    }

    @Override
    public void set(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        JsonStringHelperKt.throwIfIsNotAJsonCompliantString(key);
        JsonValue purified = PurifierKt.purify(value);
        JsonContainerHelperKt.throwIfHasAReferenceOnMe(this, purified);
        this.hashMap.put(key, purified);
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.hashMap.remove(key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject clone() {
        void this_$iv;
        void $this$mapTo$iv$iv;
        JsonKraken jsonKraken = JsonKraken.INSTANCE;
        Map<String, JsonValue> $this$map$iv = this.hashMap;
        boolean $i$f$map = false;
        Map<String, JsonValue> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)JsonValueHelperKt.copy((JsonValue)it.getValue()));
            collection.add(pair);
        }
        Map value$iv = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        boolean $i$f$transform = false;
        JsonValue result$iv = PurifierKt.purify(value$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$cast = false;
        if (!(result$iv instanceof JsonObject)) {
            throw (Throwable)new UnexpectedJsonValueException((KClass<? extends JsonValue>)Reflection.getOrCreateKotlinClass(JsonObject.class), (KClass<? extends JsonValue>)Reflection.getOrCreateKotlinClass(result$iv.getClass()));
        }
        return (JsonObject)result$iv;
    }

    @NotNull
    public final Set<String> getKeys() {
        return this.hashMap.keySet();
    }

    @NotNull
    public final Collection<JsonValue> getValues() {
        return this.hashMap.values();
    }

    public final boolean containsKey(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.hashMap.containsKey(key);
    }

    @Override
    public int getSize() {
        return this.hashMap.size();
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, JsonValue>> iterator() {
        Map<String, JsonValue> map = this.hashMap;
        boolean bl = false;
        return map.entrySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    public JsonObject() {
        super(null);
        Map map;
        JsonObject jsonObject = this;
        boolean bl = false;
        jsonObject.hashMap = map = (Map)new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public JsonObject(Pair<String, ? extends Object> ... properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        this();
        Pair<String, ? extends Object>[] $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        Pair<String, ? extends Object>[] pairArray = $this$forEach$iv;
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            void key;
            Pair<String, ? extends Object> element$iv;
            Pair<String, ? extends Object> $dstr$key$value = element$iv = pairArray[i];
            boolean bl = false;
            String string = (String)$dstr$key$value.component1();
            Object value = $dstr$key$value.component2();
            JsonStringHelperKt.throwIfIsNotAJsonCompliantString((String)key);
            this.hashMap.put((String)key, PurifierKt.purify(value));
        }
    }
}

