/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.parsers;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.jemzart.jsonkraken.exceptions.InvalidJsonTypeException;
import net.jemzart.jsonkraken.values.JsonArray;
import net.jemzart.jsonkraken.values.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0007J\u0012\u0010\u0019\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002J\u0019\u0010!\u001a\u00020\u0012*\u00060\u000bj\u0002`\f2\u0006\u0010\u0002\u001a\u00020\u0007H\u0082\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/jemzart/jsonkraken/parsers/Serializer;", "", "value", "formatted", "", "(Ljava/lang/Object;Z)V", "indentation", "", "nesting", "", "stb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tabs", "getTabs", "()Ljava/lang/String;", "writeDelimiter", "Lkotlin/Function0;", "", "writeEnd", "Lkotlin/Function1;", "writeKey", "writeStart", "writeTabs", "create", "parsePrimitive", "writeArray", "arr", "Lnet/jemzart/jsonkraken/values/JsonArray;", "writeObject", "obj", "Lnet/jemzart/jsonkraken/values/JsonObject;", "writeValue", "plusAssign", "jsonkraken"})
public final class Serializer {
    private final StringBuilder stb;
    private final String indentation = "\t";
    private int nesting;
    private final Function1<String, Unit> writeKey;
    private final Function1<String, Unit> writeStart;
    private final Function1<String, Unit> writeEnd;
    private final Function0<Unit> writeDelimiter;
    private final Function0<Unit> writeTabs;
    private final Object value;

    private final void plusAssign(@NotNull StringBuilder $receiver, String value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.append(value);
    }

    private final String getTabs() {
        int $i$f$getTabs = 0;
        return StringsKt.repeat((CharSequence)this.indentation, (int)this.nesting);
    }

    @NotNull
    public final String create() {
        this.writeValue(this.value);
        String string = this.stb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stb.toString()");
        return string;
    }

    private final void writeValue(Object value) {
        Object object = value;
        if (object instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else if (object instanceof JsonObject) {
            this.writeObject((JsonObject)value);
        } else {
            this.parsePrimitive(value);
        }
    }

    private final void writeObject(JsonObject obj) {
        this.writeStart.invoke((Object)"{");
        boolean first = true;
        for (Pair<String, Object> pair : obj) {
            if (first) {
                this.writeTabs.invoke();
                first = false;
            } else {
                this.writeDelimiter.invoke();
            }
            this.writeKey.invoke(pair.getFirst());
            this.writeValue(pair.getSecond());
        }
        this.writeEnd.invoke((Object)"}");
    }

    private final void writeArray(JsonArray arr) {
        this.writeStart.invoke((Object)"[");
        boolean first = true;
        for (Object item : arr) {
            if (first) {
                this.writeTabs.invoke();
                first = false;
            } else {
                this.writeDelimiter.invoke();
            }
            this.writeValue(item);
        }
        this.writeEnd.invoke((Object)"]");
    }

    private final void parsePrimitive(Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "null";
        } else if (object instanceof String || object instanceof Character) {
            string = "" + '\"' + value + '\"';
        } else if (object instanceof Boolean) {
            string = value.toString();
        } else if (object instanceof Number) {
            string = (((Number)value).doubleValue() % 1.0 == 0.0 ? (Number)((Number)value).longValue() : (Number)((Number)value)).toString();
        } else {
            throw (Throwable)new InvalidJsonTypeException(value);
        }
        String str = string;
        this.stb.append(str);
    }

    public Serializer(@Nullable Object value, boolean formatted) {
        this.value = value;
        this.stb = new StringBuilder();
        this.indentation = "\t";
        this.writeKey = formatted ? (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke(@NotNull String key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), '\"' + key + "\": ");
            }
            {
                this.this$0 = serializer;
                super(1);
            }
        } : (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke(@NotNull String key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), '\"' + key + "\":");
            }
            {
                this.this$0 = serializer;
                super(1);
            }
        };
        this.writeStart = formatted ? (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), value + '\n');
                Serializer serializer = this.this$0;
                Serializer.access$setNesting$p(serializer, Serializer.access$getNesting$p(serializer) + 1);
                Serializer.access$getNesting$p(serializer);
            }
            {
                this.this$0 = serializer;
                super(1);
            }
        } : (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), value);
            }
            {
                this.this$0 = serializer;
                super(1);
            }
        };
        this.writeEnd = formatted ? (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), "\n");
                Serializer serializer = this.this$0;
                Serializer.access$setNesting$p(serializer, Serializer.access$getNesting$p(serializer) + -1);
                Serializer.access$getNesting$p(serializer);
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), Serializer.access$getTabs$p(this.this$0) + value);
            }
            {
                this.this$0 = serializer;
                super(1);
            }
        } : (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), value);
            }
            {
                this.this$0 = serializer;
                super(1);
            }
        };
        this.writeDelimiter = formatted ? (Function0)new Function0<Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke() {
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), ",\n" + Serializer.access$getTabs$p(this.this$0));
            }
            {
                this.this$0 = serializer;
                super(0);
            }
        } : (Function0)new Function0<Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke() {
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), ",");
            }
            {
                this.this$0 = serializer;
                super(0);
            }
        };
        this.writeTabs = formatted ? (Function0)new Function0<Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke() {
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), Serializer.access$getTabs$p(this.this$0));
            }
            {
                this.this$0 = serializer;
                super(0);
            }
        } : (Function0)new Function0<Unit>(this){
            final /* synthetic */ Serializer this$0;

            public final void invoke() {
                Serializer.access$plusAssign(this.this$0, Serializer.access$getStb$p(this.this$0), "");
            }
            {
                this.this$0 = serializer;
                super(0);
            }
        };
    }

    public static final /* synthetic */ void access$setNesting$p(Serializer $this, int n) {
        $this.nesting = n;
    }

    public static final /* synthetic */ void access$plusAssign(Serializer $this, StringBuilder $receiver, String value) {
        $this.plusAssign($receiver, value);
    }

    public static final /* synthetic */ StringBuilder access$getStb$p(Serializer $this) {
        return $this.stb;
    }

    public static final /* synthetic */ String access$getTabs$p(Serializer $this) {
        return $this.getTabs();
    }
}

