/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.parsers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.jemzart.jsonkraken.JSONKrakenKt;
import net.jemzart.jsonkraken.constants.Escapable;
import net.jemzart.jsonkraken.exceptions.TokenExpectationException;
import net.jemzart.jsonkraken.helpers.CharHelperKt;
import net.jemzart.jsonkraken.values.JsonArray;
import net.jemzart.jsonkraken.values.JsonObject;
import net.jemzart.jsonkraken.wrappers.BoundedString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0011\n\u0002\b\b\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0001H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0003H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u0001H\u0002J\b\u0010$\u001a\u00020\u0014H\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\t\u0010&\u001a\u00020\u0014H\u0082\u0010J\b\u0010'\u001a\u00020\u0014H\u0002J\b\u0010(\u001a\u00020\u0014H\u0002J\t\u0010)\u001a\u00020\u0014H\u0082\u0010J\b\u0010*\u001a\u00020\u0014H\u0002J\t\u0010+\u001a\u00020\u0014H\u0082\u0010J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0002J\b\u0010/\u001a\u00020\u0014H\u0002J \u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0003H\u0002J+\u00103\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u000b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b052\u0006\u0010-\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u00106J+\u00107\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u000b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b052\u0006\u0010-\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u00106J\u0018\u00108\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0018\u00109\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0018\u0010:\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0003H\u0002J\b\u0010;\u001a\u00020\u0014H\u0002R\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00020\u0010X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lnet/jemzart/jsonkraken/parsers/Deserializer;", "", "raw", "", "(Ljava/lang/String;)V", "errorLocalization", "getErrorLocalization", "()Ljava/lang/String;", "errorPreview", "getErrorPreview", "first", "", "getFirst", "()C", "last", "", "Lnet/jemzart/jsonkraken/wrappers/BoundedString;", "Ljava/lang/String;", "start", "advance", "", "advanceAndTrim", "create", "create$jsonkraken", "deserializeArray", "Lnet/jemzart/jsonkraken/values/JsonArray;", "deserializeFalse", "", "deserializeNull", "", "deserializeNumber", "deserializeObject", "Lnet/jemzart/jsonkraken/values/JsonObject;", "deserializeString", "deserializeTrue", "deserializeValue", "dot", "e", "firstDigitLoop", "minus", "oneToNine", "secondDigitLoop", "skipSpaces", "thirdDigitLoop", "throwError", "context", "detail", "validateEOF", "validateEquality", "char", "expectation", "validateExclusion", "expectations", "", "(C[Ljava/lang/Character;Ljava/lang/String;)V", "validateInclusion", "validateIsDecimal", "validateIsHexadecimal", "validateIsNotISOControlCharacterOtherThanDelete", "zero", "Companion", "jsonkraken"})
public final class Deserializer {
    private final String raw;
    private final int last;
    private int start;
    public static final int PREVIEW_OFFSET_BACK = 20;
    public static final int PREVIEW_OFFSET_FORWARD = 20;
    @NotNull
    public static final String PARSING_TRUE = "parsing true";
    @NotNull
    public static final String PARSING_FALSE = "parsing false";
    @NotNull
    public static final String PARSING_NULL = "parsing null";
    @NotNull
    public static final String PARSING_NUMBER = "parsing number";
    @NotNull
    public static final String PARSING_STRING = "parsing string";
    @NotNull
    public static final String PARSING_OBJECT = "parsing object";
    @NotNull
    public static final String PARSING_ARRAY = "parsing array";
    @NotNull
    public static final String VERIFYING_END_OF_PARSE = "verifying end of parse";
    @Deprecated
    public static final Companion Companion = new Companion(null);

    private final char getFirst() {
        return BoundedString.get-impl(this.raw, this.start);
    }

    private final String getErrorLocalization() {
        return "at character " + this.start;
    }

    private final String getErrorPreview() {
        int offsetBack = this.start - 20;
        int offsetForward = this.start + 20;
        boolean leftHorizon = offsetBack >= 0;
        boolean rightHorizon = offsetForward <= this.last;
        String left = BoundedString.substring-impl(this.raw, leftHorizon ? offsetBack : 0, this.start);
        String right = BoundedString.substring-impl(this.raw, this.start, rightHorizon ? offsetForward : this.last);
        left = (leftHorizon ? ".. " : "") + left;
        right = right + (rightHorizon ? " .." : "");
        String arrow = StringsKt.padStart$default((String)"^", (int)(left.length() + 1), (char)'\u0000', (int)2, null);
        return left + right + "\n" + arrow;
    }

    private final Object deserializeValue() {
        Object object;
        switch (this.getFirst()) {
            case '{': {
                object = this.deserializeObject();
                break;
            }
            case '[': {
                object = this.deserializeArray();
                break;
            }
            case '\"': {
                object = this.deserializeString();
                break;
            }
            case 't': {
                object = this.deserializeTrue();
                break;
            }
            case 'f': {
                object = this.deserializeFalse();
                break;
            }
            case 'n': {
                object = this.deserializeNull();
                break;
            }
            default: {
                object = this.deserializeNumber();
            }
        }
        return object;
    }

    private final boolean deserializeTrue() {
        Deserializer deserializer = this;
        ++deserializer.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer.start), 'r', PARSING_TRUE);
        Deserializer deserializer2 = this;
        ++deserializer2.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer2.start), 'u', PARSING_TRUE);
        Deserializer deserializer3 = this;
        ++deserializer3.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer3.start), 'e', PARSING_TRUE);
        this.advanceAndTrim();
        return true;
    }

    private final boolean deserializeFalse() {
        Deserializer deserializer = this;
        ++deserializer.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer.start), 'a', PARSING_FALSE);
        Deserializer deserializer2 = this;
        ++deserializer2.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer2.start), 'l', PARSING_FALSE);
        Deserializer deserializer3 = this;
        ++deserializer3.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer3.start), 's', PARSING_FALSE);
        Deserializer deserializer4 = this;
        ++deserializer4.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer4.start), 'e', PARSING_FALSE);
        this.advanceAndTrim();
        return false;
    }

    private final Void deserializeNull() {
        Deserializer deserializer = this;
        ++deserializer.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer.start), 'u', PARSING_NULL);
        Deserializer deserializer2 = this;
        ++deserializer2.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer2.start), 'l', PARSING_NULL);
        Deserializer deserializer3 = this;
        ++deserializer3.start;
        this.validateEquality(BoundedString.get-impl(this.raw, deserializer3.start), 'l', PARSING_NULL);
        this.advanceAndTrim();
        return null;
    }

    private final String deserializeString() {
        this.advance();
        int valueStart = this.start;
        while (true) {
            if (this.getFirst() == '\\') {
                this.advance();
                if (this.getFirst() == 'u') {
                    Deserializer deserializer = this;
                    ++deserializer.start;
                    this.validateIsHexadecimal(BoundedString.get-impl(this.raw, deserializer.start), PARSING_STRING);
                    Deserializer deserializer2 = this;
                    ++deserializer2.start;
                    this.validateIsHexadecimal(BoundedString.get-impl(this.raw, deserializer2.start), PARSING_STRING);
                    Deserializer deserializer3 = this;
                    ++deserializer3.start;
                    this.validateIsHexadecimal(BoundedString.get-impl(this.raw, deserializer3.start), PARSING_STRING);
                    Deserializer deserializer4 = this;
                    ++deserializer4.start;
                    this.validateIsHexadecimal(BoundedString.get-impl(this.raw, deserializer4.start), PARSING_STRING);
                    this.advance();
                    continue;
                }
                this.validateInclusion(this.getFirst(), Escapable.Companion.getMonoChars(), PARSING_STRING);
                this.advance();
                continue;
            }
            if (this.getFirst() == '\"') {
                String value = BoundedString.substring-impl(this.raw, valueStart, this.start);
                this.advanceAndTrim();
                return value;
            }
            this.validateExclusion(BoundedString.get-impl(this.raw, this.start), Escapable.Companion.getWhiteSpaceChars(), PARSING_STRING);
            this.validateIsNotISOControlCharacterOtherThanDelete(BoundedString.get-impl(this.raw, this.start), PARSING_STRING);
            this.advance();
        }
    }

    private final void minus() {
        this.advance();
        char c = this.getFirst();
        if (c == '0') {
            this.zero();
        } else {
            char c2 = c;
            if ('1' <= c2 && '9' >= c2) {
                this.oneToNine();
            } else {
                this.validateIsDecimal(this.getFirst(), PARSING_NUMBER);
            }
        }
    }

    private final void dot() {
        char c;
        this.advance();
        char c2 = c = this.getFirst();
        if ('0' <= c2 && '9' >= c2) {
            this.secondDigitLoop();
        } else {
            this.validateIsDecimal(this.getFirst(), PARSING_NUMBER);
        }
    }

    private final void e() {
        char c;
        this.advance();
        if (this.getFirst() == '+' || this.getFirst() == '-') {
            this.advance();
        }
        if ('0' <= (c = this.getFirst()) && '9' >= c) {
            this.thirdDigitLoop();
        } else {
            this.validateIsDecimal(this.getFirst(), PARSING_NUMBER);
        }
    }

    private final void zero() {
        this.advance();
        if (this.start == this.last) {
            return;
        }
        switch (this.getFirst()) {
            case '.': {
                this.dot();
                break;
            }
            case 'E': 
            case 'e': {
                this.e();
            }
        }
    }

    private final void oneToNine() {
        this.advance();
        if (this.start == this.last) {
            return;
        }
        char c = this.getFirst();
        if (c == '.') {
            this.dot();
        } else if (c == 'e' || c == 'E') {
            this.e();
        } else {
            char c2 = c;
            if ('0' <= c2 && '9' >= c2) {
                this.firstDigitLoop();
            }
        }
    }

    private final void firstDigitLoop() {
        char c;
        char c2;
        do {
            this.advance();
            if (this.start == this.last) {
                return;
            }
            c = this.getFirst();
            if (c == '.') {
                this.dot();
                break;
            }
            if (c != 'e' && c != 'E') continue;
            this.e();
            break;
        } while ('0' <= (c2 = c) && '9' >= c2);
    }

    private final void secondDigitLoop() {
        char c;
        char c2;
        do {
            this.advance();
            if (this.start == this.last) {
                return;
            }
            c = this.getFirst();
            if (c != 'e' && c != 'E') continue;
            this.e();
            break;
        } while ('0' <= (c2 = c) && '9' >= c2);
    }

    private final void thirdDigitLoop() {
        char c;
        char c2;
        do {
            this.advance();
            if (this.start != this.last) continue;
            return;
        } while ('0' <= (c2 = (c = this.getFirst())) && '9' >= c2);
    }

    private final Object deserializeNumber() {
        int valueStart = this.start;
        char c = this.getFirst();
        if (c == '-') {
            this.minus();
        } else if (c == '0') {
            this.zero();
        } else {
            char c2 = c;
            if ('1' <= c2 && '9' >= c2) {
                this.oneToNine();
            } else {
                this.validateIsDecimal(this.getFirst(), PARSING_NUMBER);
            }
        }
        String string = BoundedString.substring-impl(this.raw, valueStart, this.start);
        double value = Double.parseDouble(string);
        this.skipSpaces();
        return DoubleHelperKt.normalize(value);
    }

    private final JsonObject deserializeObject() {
        JsonObject obj = new JsonObject();
        this.advanceAndTrim();
        if (this.getFirst() != '}') {
            while (true) {
                this.validateEquality(this.getFirst(), '\"', PARSING_OBJECT);
                String name = this.deserializeString();
                this.validateEquality(this.getFirst(), ':', PARSING_OBJECT);
                this.advanceAndTrim();
                obj.uncheckedSet$jsonkraken(name, this.deserializeValue());
                if (this.getFirst() == ',') {
                    this.advanceAndTrim();
                    continue;
                }
                if (this.getFirst() == '}') break;
                this.validateInclusion(this.getFirst(), new Character[]{Character.valueOf(','), Character.valueOf('}')}, PARSING_OBJECT);
            }
        }
        this.advanceAndTrim();
        return obj;
    }

    private final JsonArray deserializeArray() {
        JsonArray arr = new JsonArray();
        this.advanceAndTrim();
        if (this.getFirst() != ']') {
            while (true) {
                arr.uncheckedAdd$jsonkraken(this.deserializeValue());
                if (this.getFirst() == ',') {
                    this.advanceAndTrim();
                    continue;
                }
                if (this.getFirst() == ']') break;
                this.validateInclusion(this.getFirst(), new Character[]{Character.valueOf(','), Character.valueOf(']')}, PARSING_ARRAY);
            }
        }
        this.advanceAndTrim();
        return arr;
    }

    @Nullable
    public final Object create$jsonkraken() {
        this.skipSpaces();
        Object result = this.deserializeValue();
        this.validateEOF();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void skipSpaces() {
        int n = this.start;
        int n2 = this.last;
        while (n < n2) {
            void i;
            if (!CharHelperKt.isWhiteSpace(BoundedString.get-impl(this.raw, (int)i))) {
                this.start = i;
                return;
            }
            ++i;
        }
        this.start = this.last;
    }

    private final void advanceAndTrim() {
        ++this.start;
        this.skipSpaces();
    }

    private final void advance() {
        ++this.start;
    }

    private final void validateEquality(char c, char expectation, String context) {
        if (c != expectation) {
            this.throwError(context, "Expected \"" + expectation + "\", found \"" + c + "\".");
        }
    }

    private final void validateIsHexadecimal(char c, String context) {
        if (!CharHelperKt.isHexadecimal(c)) {
            this.throwError(context, "Expected a hexadecimal character, found \"" + c + "\".");
        }
    }

    private final void validateIsDecimal(char c, String context) {
        if (!CharHelperKt.isDecimal(c)) {
            this.throwError(context, "Expected a decimal character, found \"" + c + "\".");
        }
    }

    private final void validateIsNotISOControlCharacterOtherThanDelete(char c, String context) {
        if (CharHelperKt.isISOControlCharacterOtherThanDelete(c)) {
            this.throwError(context, "" + '\"' + c + "\" is invalid in this context.");
        }
    }

    private final void validateEOF() {
        if (this.start != this.last) {
            this.throwError(VERIFYING_END_OF_PARSE, "Invalid characters have been found after the end of the outermost json structure.Should they be removed, the parse would succeed.");
        }
    }

    private final void validateInclusion(char c, Character[] expectations, String context) {
        Character[] characterArray = expectations;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char expectation = characterArray[i].charValue();
            if (c != expectation) continue;
            return;
        }
        String arr = JSONKrakenKt.toJsonString$default(new JsonArray(new Object[]{expectations}), false, 1, null);
        this.throwError(context, "Expected one of " + arr + ", found \"" + c + "\".");
    }

    private final void validateExclusion(char c, Character[] expectations, String context) {
        Character[] characterArray = expectations;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char expectation = characterArray[i].charValue();
            if (c != expectation) continue;
            String arr = JSONKrakenKt.toJsonString$default(new JsonArray(new Object[]{expectations}), false, 1, null);
            this.throwError(context, "None of " + arr + " expected, found \"" + c + "\".");
        }
    }

    private final void throwError(String context, String detail) {
        String message = "\nError " + this.getErrorLocalization() + " while " + context + '.' + '\n' + detail + '\n' + this.getErrorPreview();
        throw (Throwable)new TokenExpectationException(message);
    }

    public Deserializer(@NotNull String raw) {
        Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
        this.raw = BoundedString.constructor-impl(raw);
        this.last = raw.length();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/jemzart/jsonkraken/parsers/Deserializer$Companion;", "", "()V", "PARSING_ARRAY", "", "PARSING_FALSE", "PARSING_NULL", "PARSING_NUMBER", "PARSING_OBJECT", "PARSING_STRING", "PARSING_TRUE", "PREVIEW_OFFSET_BACK", "", "PREVIEW_OFFSET_FORWARD", "VERIFYING_END_OF_PARSE", "jsonkraken"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

