/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.jemzart.jsonkraken.JSONKrakenKt;
import net.jemzart.jsonkraken.exceptions.CircularReferenceException;
import net.jemzart.jsonkraken.exceptions.InvalidJsonTypeException;
import net.jemzart.jsonkraken.helpers.StringHelperKt;
import net.jemzart.jsonkraken.values.JsonValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001H\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"purify", "", "container", "Lnet/jemzart/jsonkraken/values/JsonValue;", "jsonkraken"})
public final class AnyHelperKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object purify(@Nullable Object $receiver) {
        Object object;
        Object object2 = $receiver;
        if (object2 instanceof Number) {
            object = DoubleHelperKt.normalize(((Number)$receiver).doubleValue());
        } else if (object2 instanceof String) {
            object = StringHelperKt.validate((String)$receiver);
        } else if (object2 instanceof Character) {
            object = AnyHelperKt.purify($receiver.toString());
        } else if (object2 instanceof JsonValue || object2 instanceof Boolean || object2 == null) {
            object = $receiver;
        } else if (object2 instanceof Object[]) {
            object = AnyHelperKt.purify(ArraysKt.asIterable((Object[])((Object[])$receiver)));
        } else if (object2 instanceof Map) {
            void $receiver$iv$iv;
            Map $receiver$iv;
            Map map = $receiver$iv = (Map)$receiver;
            Collection destination$iv$iv = new ArrayList($receiver$iv.size());
            void var5_5 = $receiver$iv$iv;
            Iterator iterator = var5_5.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                if (k == null || (k = k.toString()) == null) {
                    throw (Throwable)new NullPointerException("Why are you using null as a key for a map?");
                }
                Object key = k;
                Pair pair = TuplesKt.to(key, it.getValue());
                collection.add(pair);
            }
            object = JSONKrakenKt.toJsonObject(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
        } else if (object2 instanceof Iterable) {
            object = JSONKrakenKt.toJsonArray((Iterable)$receiver);
        } else {
            throw (Throwable)new InvalidJsonTypeException($receiver);
        }
        return object;
    }

    @Nullable
    public static final Object purify(@Nullable Object $receiver, @NotNull JsonValue container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        if ($receiver instanceof JsonValue) {
            if (Intrinsics.areEqual((Object)$receiver, (Object)container)) {
                throw (Throwable)new CircularReferenceException(container, (JsonValue)$receiver);
            }
            if (((JsonValue)$receiver).references(container)) {
                throw (Throwable)new CircularReferenceException(container, (JsonValue)$receiver);
            }
            return $receiver;
        }
        return AnyHelperKt.purify($receiver);
    }
}

