/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.jemzart.jsonkraken.JSONKrakenKt;
import net.jemzart.jsonkraken.exceptions.CircularReferenceException;
import net.jemzart.jsonkraken.exceptions.InvalidJsonTypeException;
import net.jemzart.jsonkraken.helpers.IterableHelperKt;
import net.jemzart.jsonkraken.helpers.ValidateKt;
import net.jemzart.jsonkraken.values.JsonValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030\u0002B7\b\u0016\u0012.\u0010\u0006\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030\u0007\"\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0018\u001a\u00020\u0000H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0011H\u0096\u0002J\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0004H\u0096\u0002J\u001d\u0010\u001e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030\u001fH\u0096\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u001b\u0010$\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\u001b\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\u001f\u0010%\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b&R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lnet/jemzart/jsonkraken/values/JsonObject;", "Lnet/jemzart/jsonkraken/values/JsonValue;", "", "Lkotlin/Pair;", "", "", "properties", "", "([Lkotlin/Pair;)V", "()V", "keys", "", "getKeys", "()Ljava/util/Set;", "map", "", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "clone", "exists", "", "index", "name", "get", "iterator", "", "references", "value", "remove", "", "set", "uncheckedSet", "uncheckedSet$jsonkraken", "jsonkraken"})
public final class JsonObject
implements JsonValue,
Iterable<Pair<? extends String, ? extends Object>>,
KMappedMarker {
    private final Map<String, Object> map;

    @Override
    public int getSize() {
        return this.map.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Pair<String, Object>> iterator() {
        void var3_3;
        void $receiver$iv$iv;
        Map<String, Object> $receiver$iv;
        Map<String, Object> map = $receiver$iv = this.map;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var4_4 = $receiver$iv$iv;
        Iterator iterator = var4_4.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            collection.add(pair);
        }
        return ((List)var3_3).iterator();
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.map.get(name);
    }

    @Override
    public void set(@NotNull String name, @Nullable Object value) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ValidateKt.validate(name);
        Map<String, Object> map = this.map;
        JsonObject $receiver$iv = this;
        boolean validateCircularReference$iv = true;
        if (value == null) {
            object = null;
        } else {
            Object object2 = value;
            if (object2 instanceof Number) {
                double number$iv = ((Number)value).doubleValue();
                object = number$iv == 0.0 ? 0.0 : number$iv;
            } else if (object2 instanceof String) {
                ValidateKt.validate((String)value);
                object = value;
            } else if (object2 instanceof Boolean) {
                object = value;
            } else if (object2 instanceof Character) {
                String result$iv = value.toString();
                ValidateKt.validate(result$iv);
                object = result$iv;
            } else if (object2 instanceof JsonValue) {
                if (Intrinsics.areEqual((Object)$receiver$iv, (Object)value)) {
                    throw (Throwable)new CircularReferenceException($receiver$iv, (JsonValue)value);
                }
                if (((JsonValue)value).references($receiver$iv)) {
                    throw (Throwable)new CircularReferenceException($receiver$iv, (JsonValue)value);
                }
                object = value;
            } else {
                throw (Throwable)new InvalidJsonTypeException(value);
            }
        }
        Object object3 = object;
        map.put(name, object3);
    }

    @Override
    public void remove(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.map.remove(name);
    }

    @Override
    public boolean exists(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.map.containsKey(name);
    }

    @NotNull
    public final Set<String> getKeys() {
        return this.map.keySet();
    }

    @NotNull
    public final Collection<Object> getValues() {
        return this.map.values();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject clone() {
        void var3_3;
        void $receiver$iv$iv;
        Map<String, Object> $receiver$iv;
        Map<String, Object> map = $receiver$iv = this.map;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var4_4 = $receiver$iv$iv;
        Iterator iterator = var4_4.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            Object k = it.getKey();
            if (it.getValue() instanceof JsonValue) {
                Object v = it.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.jemzart.jsonkraken.values.JsonValue");
                }
                object = ((JsonValue)v).clone();
            } else {
                object = it.getValue();
            }
            Pair pair = TuplesKt.to(k, object);
            collection.add(pair);
        }
        return JSONKrakenKt.toJsonObject(MapsKt.toMap((Iterable)((List)var3_3)));
    }

    public final void uncheckedSet$jsonkraken(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Map<String, Object> map = this.map;
        map.put(name, value);
    }

    @Override
    public boolean references(@NotNull JsonValue value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return IterableHelperKt.references((Iterable<? extends Object>)this.map.values(), value);
    }

    @Override
    @Nullable
    public Object get(int index) {
        return this.get(String.valueOf(index));
    }

    @Override
    public void set(int index, @Nullable Object value) {
        this.set(String.valueOf(index), value);
    }

    @Override
    public void remove(int index) {
        this.remove(String.valueOf(index));
    }

    @Override
    public boolean exists(int index) {
        return this.exists(String.valueOf(index));
    }

    public JsonObject() {
        Map map;
        JsonObject jsonObject = this;
        jsonObject.map = map = (Map)new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public JsonObject(Pair<String, ? extends Object> ... properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        this();
        for (Pair<String, ? extends Object> property : properties) {
            Object object;
            void value$iv;
            ValidateKt.validate((String)property.getFirst());
            Object object2 = this;
            Object object3 = property.getSecond();
            boolean validateCircularReference$iv = false;
            if (value$iv == null) {
                object = null;
            } else {
                void var10_11 = value$iv;
                if (var10_11 instanceof Number) {
                    double number$iv = ((Number)value$iv).doubleValue();
                    object = number$iv == 0.0 ? 0.0 : number$iv;
                } else if (var10_11 instanceof String) {
                    ValidateKt.validate((String)value$iv);
                    object = value$iv;
                } else if (var10_11 instanceof Boolean) {
                    object = value$iv;
                } else if (var10_11 instanceof Character) {
                    String result$iv = value$iv.toString();
                    ValidateKt.validate(result$iv);
                    object = result$iv;
                } else if (var10_11 instanceof JsonValue) {
                    object = value$iv;
                } else {
                    throw (Throwable)new InvalidJsonTypeException(value$iv);
                }
            }
            Double purified = object;
            object2 = this.map;
            object3 = property.getFirst();
            Double d = purified;
            object2.put(object3, d);
        }
    }
}

