/*
 * Decompiled with CFR 0.152.
 */
package net.jemzart.jsonkraken.parsers;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.jemzart.jsonkraken.exceptions.InvalidJsonTypeException;
import net.jemzart.jsonkraken.values.JsonArray;
import net.jemzart.jsonkraken.values.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u0007J\u0012\u0010\u001e\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018\u00a8\u0006&"}, d2={"Lnet/jemzart/jsonkraken/parsers/ObjectToStringParser;", "", "value", "formatted", "", "(Ljava/lang/Object;Z)V", "indentation", "", "nesting", "", "stb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tabs", "getTabs", "()Ljava/lang/String;", "writeDelimiter", "Lkotlin/Function0;", "", "getWriteDelimiter", "()Lkotlin/jvm/functions/Function0;", "writeEnd", "Lkotlin/Function1;", "getWriteEnd", "()Lkotlin/jvm/functions/Function1;", "writeKey", "getWriteKey", "writeStart", "getWriteStart", "create", "parsePrimitive", "writeArray", "arr", "Lnet/jemzart/jsonkraken/values/JsonArray;", "writeObject", "obj", "Lnet/jemzart/jsonkraken/values/JsonObject;", "writeValue", "jsonkraken"})
public final class ObjectToStringParser {
    private final StringBuilder stb;
    private final String indentation = "\t";
    private int nesting;
    @NotNull
    private final Function1<String, Unit> writeKey;
    @NotNull
    private final Function1<String, Unit> writeStart;
    @NotNull
    private final Function1<String, Unit> writeEnd;
    @NotNull
    private final Function0<Unit> writeDelimiter;
    private final Object value;

    private final String getTabs() {
        return StringsKt.repeat((CharSequence)this.indentation, (int)this.nesting);
    }

    @NotNull
    public final Function1<String, Unit> getWriteKey() {
        return this.writeKey;
    }

    @NotNull
    public final Function1<String, Unit> getWriteStart() {
        return this.writeStart;
    }

    @NotNull
    public final Function1<String, Unit> getWriteEnd() {
        return this.writeEnd;
    }

    @NotNull
    public final Function0<Unit> getWriteDelimiter() {
        return this.writeDelimiter;
    }

    @NotNull
    public final String create() {
        this.writeValue(this.value);
        String string = this.stb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stb.toString()");
        return string;
    }

    private final void writeValue(Object value) {
        Object object = value;
        if (object instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else if (object instanceof JsonObject) {
            this.writeObject((JsonObject)value);
        } else {
            this.parsePrimitive(value);
        }
    }

    private final void writeObject(JsonObject obj) {
        this.writeStart.invoke((Object)"{");
        boolean first = true;
        for (Pair<String, Object> pair : obj) {
            if (!first) {
                this.writeDelimiter.invoke();
            } else {
                first = false;
            }
            this.writeKey.invoke(pair.getFirst());
            this.writeValue(pair.getSecond());
        }
        this.writeEnd.invoke((Object)"}");
    }

    private final void writeArray(JsonArray arr) {
        this.writeStart.invoke((Object)"[");
        boolean first = true;
        for (Object item : arr) {
            if (!first) {
                this.writeDelimiter.invoke();
            } else {
                first = false;
            }
            this.writeValue(item);
        }
        this.writeEnd.invoke((Object)"]");
    }

    private final void parsePrimitive(Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "null";
        } else if (object instanceof String || object instanceof Character) {
            string = "" + '\"' + value + '\"';
        } else if (object instanceof Boolean) {
            string = value.toString();
        } else if (object instanceof Number) {
            string = (((Number)value).doubleValue() % 1.0 == 0.0 ? (Number)((Number)value).longValue() : (Number)((Number)value)).toString();
        } else {
            throw (Throwable)new InvalidJsonTypeException(value);
        }
        String str = string;
        this.stb.append(str);
    }

    public ObjectToStringParser(@Nullable Object value, boolean formatted) {
        this.value = value;
        this.stb = new StringBuilder();
        this.indentation = "\t";
        this.writeKey = formatted ? (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke(@NotNull String key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                ObjectToStringParser.access$getStb$p(this.this$0).append('\"' + key + "\": ");
            }
            {
                this.this$0 = objectToStringParser;
                super(1);
            }
        } : (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke(@NotNull String key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                ObjectToStringParser.access$getStb$p(this.this$0).append('\"' + key + "\":");
            }
            {
                this.this$0 = objectToStringParser;
                super(1);
            }
        };
        this.writeStart = formatted ? (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                ObjectToStringParser.access$getStb$p(this.this$0).append(value + '\n');
                ObjectToStringParser objectToStringParser = this.this$0;
                ObjectToStringParser.access$setNesting$p(objectToStringParser, ObjectToStringParser.access$getNesting$p(objectToStringParser) + 1);
                ObjectToStringParser.access$getNesting$p(objectToStringParser);
                ObjectToStringParser.access$getStb$p(this.this$0).append(ObjectToStringParser.access$getTabs$p(this.this$0));
            }
            {
                this.this$0 = objectToStringParser;
                super(1);
            }
        } : (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                ObjectToStringParser.access$getStb$p(this.this$0).append(value);
            }
            {
                this.this$0 = objectToStringParser;
                super(1);
            }
        };
        this.writeEnd = formatted ? (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                ObjectToStringParser.access$getStb$p(this.this$0).append("\n");
                ObjectToStringParser objectToStringParser = this.this$0;
                ObjectToStringParser.access$setNesting$p(objectToStringParser, ObjectToStringParser.access$getNesting$p(objectToStringParser) + -1);
                ObjectToStringParser.access$getNesting$p(objectToStringParser);
                ObjectToStringParser.access$getStb$p(this.this$0).append(ObjectToStringParser.access$getTabs$p(this.this$0) + value);
            }
            {
                this.this$0 = objectToStringParser;
                super(1);
            }
        } : (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                ObjectToStringParser.access$getStb$p(this.this$0).append(value);
            }
            {
                this.this$0 = objectToStringParser;
                super(1);
            }
        };
        this.writeDelimiter = formatted ? (Function0)new Function0<Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke() {
                ObjectToStringParser.access$getStb$p(this.this$0).append(",\n" + ObjectToStringParser.access$getTabs$p(this.this$0));
            }
            {
                this.this$0 = objectToStringParser;
                super(0);
            }
        } : (Function0)new Function0<Unit>(this){
            final /* synthetic */ ObjectToStringParser this$0;

            public final void invoke() {
                ObjectToStringParser.access$getStb$p(this.this$0).append(",");
            }
            {
                this.this$0 = objectToStringParser;
                super(0);
            }
        };
    }

    public static final /* synthetic */ void access$setNesting$p(ObjectToStringParser $this, int n) {
        $this.nesting = n;
    }

    @NotNull
    public static final /* synthetic */ StringBuilder access$getStb$p(ObjectToStringParser $this) {
        return $this.stb;
    }

    @NotNull
    public static final /* synthetic */ String access$getTabs$p(ObjectToStringParser $this) {
        return $this.getTabs();
    }
}

