/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.javapla.jawn.core.Config;
import net.javapla.jawn.core.Up;
import net.javapla.jawn.core.server.Server;
import net.javapla.jawn.core.server.WebSocket;
import net.javapla.jawn.core.server.WebSocketCloseStatus;
import net.javapla.jawn.core.server.WebSocketMessage;
import net.javapla.jawn.server.undertow.UndertowRequest;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

class UndertowWebSocket
extends AbstractReceiveListener
implements WebSocket.Listener,
WebSocket,
WebSocketCallback<Void> {
    private final Config config;
    private final UndertowRequest req;
    private final WebSocketChannel channel;
    private final boolean dispatch;
    private final CountDownLatch ready = new CountDownLatch(1);
    private WebSocket.OnConnect onConnectCallback;
    private WebSocket.OnMessage onMessageCallback;
    private WebSocket.OnError onErrorCallback;
    private WebSocket.OnClose onCloseCallback;

    public UndertowWebSocket(Config config, UndertowRequest req, WebSocketChannel channel) {
        this.config = config;
        this.req = req;
        this.channel = channel;
        this.dispatch = req.isInIoThread();
    }

    public WebSocket.Listener onConnect(WebSocket.OnConnect callback) {
        this.onConnectCallback = callback;
        return this;
    }

    public WebSocket.Listener onMessage(WebSocket.OnMessage callback) {
        this.onMessageCallback = callback;
        return this;
    }

    public WebSocket.Listener onError(WebSocket.OnError callback) {
        this.onErrorCallback = callback;
        return this;
    }

    public WebSocket.Listener onClose(WebSocket.OnClose callback) {
        this.onCloseCallback = callback;
        return this;
    }

    public WebSocket send(String message) {
        if (this.isOpen()) {
            try {
                WebSockets.sendText((String)message, (WebSocketChannel)this.channel, (WebSocketCallback)this);
            }
            catch (Throwable e) {
                this.onError(this.channel, e);
            }
        } else {
            this.onError(this.channel, new IllegalStateException("Attemp to send a message on a closed web socket"));
        }
        return this;
    }

    public WebSocket send(byte[] message) {
        if (this.isOpen()) {
            try {
                WebSockets.sendBinary((ByteBuffer)ByteBuffer.wrap(message), (WebSocketChannel)this.channel, (WebSocketCallback)this);
            }
            catch (Throwable e) {
                this.onError(this.channel, e);
            }
        } else {
            this.onError(this.channel, new IllegalStateException("Attemp to send a message on a closed web socket"));
        }
        return this;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public WebSocket close(WebSocketCloseStatus status) {
        this.handleClose(status);
        return this;
    }

    public void complete(WebSocketChannel channel, Void context) {
    }

    public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
        this.onError(channel, throwable);
    }

    protected long getMaxTextBufferSize() {
        return this.config.getMemorySize("server.ws.max_text_message_size");
    }

    protected long getMaxBinaryBufferSize() {
        return this.config.getMemorySize("server.ws.max_binary_missage_size");
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        this.waitForConnect();
        if (this.onMessageCallback != null) {
            try (Pooled pooled = message.getData();){
                ByteBuffer merged = WebSockets.mergeBuffers((ByteBuffer[])((ByteBuffer[])pooled.getResource()));
                this.dispatch(this.webSocketTask(() -> this.onMessageCallback.onMessage((WebSocket)this, WebSocketMessage.create((byte[])merged.array())), false));
            }
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
        this.waitForConnect();
        if (this.onMessageCallback != null) {
            this.dispatch(this.webSocketTask(() -> this.onMessageCallback.onMessage((WebSocket)this, WebSocketMessage.create((String)message.getData())), false));
        }
    }

    protected void onError(WebSocketChannel channel, Throwable throwable) {
        if (Server.connectionResetByPeer((Throwable)throwable) || Up.isFatal((Throwable)throwable)) {
            this.handleClose(WebSocketCloseStatus.SERVER_ERROR);
        }
        if (this.onErrorCallback == null) {
            System.err.println("Websocket exception: " + this.req.path() + " -> " + throwable);
        } else {
            this.onErrorCallback.onError((WebSocket)this, throwable);
        }
        if (Up.isFatal((Throwable)throwable)) {
            throw Up.IO.because((Throwable)throwable);
        }
    }

    protected void onCloseMessage(CloseMessage cm, WebSocketChannel channel) {
        this.handleClose(WebSocketCloseStatus.valueOf((int)cm.getCode()).orElseGet(() -> new WebSocketCloseStatus(cm.getCode(), cm.getReason())));
    }

    private void handleClose(WebSocketCloseStatus status) {
        if (!this.channel.isCloseFrameSent()) {
            WebSockets.sendClose((int)status.code(), (String)status.reason(), (WebSocketChannel)this.channel, (WebSocketCallback)this);
        }
        try {
            if (this.onCloseCallback != null) {
                this.onCloseCallback.onClose((WebSocket)this, status);
            }
        }
        catch (Throwable e) {
            this.onError(this.channel, e);
        }
    }

    void fireConnect() {
        try {
            long timeout = this.config.getDuration("server.ws.idle_timeout", TimeUnit.MILLISECONDS);
            if (timeout > 0L) {
                this.channel.setIdleTimeout(timeout);
            }
            if (this.onConnectCallback != null) {
                this.dispatch(this.webSocketTask(() -> this.onConnectCallback.onConnect((WebSocket)this), true));
            } else {
                this.ready.countDown();
            }
            this.channel.getReceiveSetter().set((ChannelListener)this);
            this.channel.resumeReceives();
        }
        catch (Throwable e) {
            this.onError(this.channel, e);
        }
    }

    private Runnable webSocketTask(Runnable task, boolean isInit) {
        return () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                this.onError(null, e);
            }
            finally {
                if (isInit) {
                    this.ready.countDown();
                }
            }
        };
    }

    private void dispatch(Runnable task) {
        if (this.dispatch) {
            this.req.worker().execute(task);
        } else {
            task.run();
        }
    }

    private void waitForConnect() {
        try {
            this.ready.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

