/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.inject.Inject;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.javapla.jawn.core.Config;
import net.javapla.jawn.core.server.Server;
import net.javapla.jawn.core.server.ServerConfig;
import net.javapla.jawn.server.undertow.UndertowHandler;
import org.slf4j.LoggerFactory;
import org.xnio.Options;

public final class UndertowServer
implements Server {
    private final net.javapla.jawn.core.server.HttpHandler dispatcher;
    private final Config conf;
    private Undertow server;
    private GracefulShutdownHandler shutdownHandler;

    @Inject
    UndertowServer(net.javapla.jawn.core.server.HttpHandler dispatcher, Config conf) {
        this.dispatcher = dispatcher;
        this.conf = conf;
        Logger logger = (Logger)LoggerFactory.getLogger((String)"io.undertow.request");
        logger.setLevel(Level.WARN);
    }

    public void start(ServerConfig.Impl serverConfig) throws Exception {
        this.shutdownHandler = new GracefulShutdownHandler(this.createHandler(this.dispatcher));
        Undertow.Builder builder = Undertow.builder().setHandler((HttpHandler)this.shutdownHandler).addHttpListener(serverConfig.port(), serverConfig.host()).setBufferSize(serverConfig.bufferSize()).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false).setServerOption(UndertowOptions.ALWAYS_SET_DATE, (Object)true).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)false);
        this.conf.getBooleanOptionally("server.http2.enabled").ifPresent(b -> builder.setServerOption(UndertowOptions.ENABLE_HTTP2, b));
        UndertowServer.configureServerPerformance(builder, serverConfig);
        this.server = builder.build();
        this.server.start();
    }

    public void stop() throws Exception {
        this.shutdownHandler.shutdown();
        this.shutdownHandler.awaitShutdown(5000L);
        this.server.stop();
    }

    public void join() throws InterruptedException {
    }

    public Optional<Executor> executor() {
        return Optional.ofNullable(this.server.getWorker());
    }

    private final HttpHandler createHandler(net.javapla.jawn.core.server.HttpHandler dispatcher) {
        return new UndertowHandler(this.conf, dispatcher);
    }

    private static void configureServerPerformance(Undertow.Builder serverBuilder, ServerConfig.Impl config) {
        int undertow_minimum = 2;
        switch (config.performance()) {
            case HIGHEST: {
                int ioThreads = Math.max(Runtime.getRuntime().availableProcessors() * 2, undertow_minimum);
                serverBuilder.setIoThreads(ioThreads);
                break;
            }
            default: {
                int ioThreads = undertow_minimum;
                serverBuilder.setIoThreads(ioThreads);
                serverBuilder.setWorkerThreads(ioThreads);
                serverBuilder.setSocketOption(Options.BACKLOG, (Object)config.backlog());
                break;
            }
            case CUSTOM: {
                int ioThreads = Math.max(config.ioThreads(), undertow_minimum);
                serverBuilder.setIoThreads(ioThreads);
                serverBuilder.setWorkerThreads(ioThreads * 8);
                serverBuilder.setSocketOption(Options.BACKLOG, (Object)config.backlog());
            }
        }
    }
}

