/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.javapla.jawn.core.Status;
import net.javapla.jawn.core.Up;
import net.javapla.jawn.core.server.Server;
import net.javapla.jawn.core.server.ServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;

final class UndertowResponse
implements ServerResponse,
IoCallback {
    private static Logger logger = LoggerFactory.getLogger(ServerResponse.class);
    private final HttpServerExchange exchange;

    public UndertowResponse(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    public Optional<String> header(String name) {
        String value = this.exchange.getResponseHeaders().getFirst(name);
        return Optional.ofNullable(value);
    }

    public List<String> headers(String name) {
        Objects.requireNonNull(name, "A header's name is required.");
        HeaderValues values = this.exchange.getResponseHeaders().get(name);
        return values == null ? Collections.emptyList() : values;
    }

    public void header(String name, List<String> values) {
        HeaderMap headers = this.exchange.getResponseHeaders();
        headers.putAll(HttpString.tryFromString((String)name), values);
    }

    public void header(String name, String value) {
        this.exchange.getResponseHeaders().put(HttpString.tryFromString((String)name), value);
    }

    public void removeHeader(String name) {
        this.exchange.getResponseHeaders().remove(name);
    }

    public void send(byte[] bytes) throws Exception {
        this.send(ByteBuffer.wrap(bytes));
    }

    public void send(ByteBuffer buffer) throws Exception {
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Long.toString(buffer.remaining()));
        this.exchange.getResponseSender().send(buffer, (IoCallback)this);
    }

    public void send(InputStream stream) throws Exception {
        if (stream instanceof FileInputStream) {
            this.send(((FileInputStream)stream).getChannel());
            return;
        }
        this.chuncked();
        long len = this.exchange.getResponseContentLength();
        ByteRange range = ByteRange.parse(this.exchange.getRequestHeaders().getFirst(Headers.RANGE), len);
        range.apply(this);
        new ChunkedStream(len).send(Channels.newChannel(stream), this.exchange, this);
    }

    public void send(FileChannel channel) throws Exception {
        long len = channel.size();
        this.exchange.setResponseContentLength(len);
        ByteRange range = ByteRange.parse(this.exchange.getRequestHeaders().getFirst(Headers.RANGE), len);
        range.apply(this);
        channel.position(range.getStart());
        new ChunkedStream(range.getEnd()).send(channel, this.exchange, this);
    }

    public int statusCode() {
        return this.exchange.getStatusCode();
    }

    public void statusCode(int code) {
        this.exchange.setStatusCode(code);
    }

    public boolean committed() {
        return this.exchange.isResponseStarted();
    }

    public void end() {
    }

    public void reset() {
        this.exchange.getResponseHeaders().clear();
    }

    public OutputStream outputStream() {
        this.blocking();
        this.chuncked();
        return this.exchange.getOutputStream();
    }

    public void onComplete(HttpServerExchange exchange, Sender sender) {
        this.destroy(null);
    }

    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
        this.destroy(exception);
    }

    void destroy(Exception cause) {
        try {
            if (cause != null) {
                if (Server.connectionResetByPeer((Throwable)cause)) {
                    logger.debug("exception found while sending response {} {}", new Object[]{this.exchange.getRequestMethod(), this.exchange.getRequestPath(), cause});
                } else {
                    logger.error("exception found while sending response {} {}", new Object[]{this.exchange.getRequestMethod(), this.exchange.getRequestPath(), cause});
                }
            }
        }
        finally {
            this.exchange.endExchange();
        }
    }

    private void blocking() {
        if (!this.exchange.isBlocking()) {
            this.exchange.startBlocking();
        }
    }

    private void chuncked() {
        HeaderMap responseHeaders = this.exchange.getResponseHeaders();
        if (!responseHeaders.contains(Headers.CONTENT_LENGTH)) {
            this.exchange.getResponseHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
        }
    }

    static interface ByteRange {
        public static final String BYTES_RANGE = "bytes=";

        public long getStart();

        public long getEnd();

        public long getContentLength();

        public String getContentRange();

        public Status getStatusCode();

        public ByteRange apply(ServerResponse var1);

        public static ByteRange parse(String headerValue, long contentLength) {
            if (contentLength <= 0L || headerValue == null) {
                return ByteRange.noByteRange(contentLength);
            }
            if (!headerValue.startsWith(BYTES_RANGE)) {
                throw new Up(Status.REQUESTED_RANGE_NOT_SATISFIABLE, headerValue);
            }
            try {
                char ch;
                int i;
                long[] range = new long[]{-1L, -1L};
                int r = 0;
                int len = headerValue.length();
                int offset = i = BYTES_RANGE.length();
                while (i < len && (ch = headerValue.charAt(i)) != ',') {
                    if (ch == '-') {
                        if (offset < i) {
                            range[r] = Long.parseLong(headerValue.substring(offset, i).trim());
                        }
                        offset = i + 1;
                        ++r;
                    }
                    ++i;
                }
                if (offset < i) {
                    if (r == 0) {
                        throw new Up(Status.REQUESTED_RANGE_NOT_SATISFIABLE, headerValue);
                    }
                    range[r++] = Long.parseLong(headerValue.substring(offset, i).trim());
                }
                if (r == 0 || range[0] == -1L && range[1] == -1L) {
                    throw new Up(Status.REQUESTED_RANGE_NOT_SATISFIABLE, headerValue);
                }
                long start = range[0];
                long end = range[1];
                if (start == -1L) {
                    start = contentLength - end;
                    end = contentLength - 1L;
                }
                if (end == -1L || end > contentLength - 1L) {
                    end = contentLength - 1L;
                }
                if (start > end) {
                    throw new Up(Status.REQUESTED_RANGE_NOT_SATISFIABLE, headerValue);
                }
                long limit = end - start + 1L;
                return ByteRange.singleByteRange(start, limit, limit);
            }
            catch (NumberFormatException expected) {
                throw new Up(Status.REQUESTED_RANGE_NOT_SATISFIABLE, headerValue);
            }
        }

        public static ByteRange noByteRange(final long contentLength) {
            return new ByteRange(){

                @Override
                public long getStart() {
                    return 0L;
                }

                @Override
                public long getEnd() {
                    return contentLength;
                }

                @Override
                public long getContentLength() {
                    return contentLength;
                }

                @Override
                public String getContentRange() {
                    return "bytes */" + contentLength;
                }

                @Override
                public Status getStatusCode() {
                    return Status.OK;
                }

                @Override
                public ByteRange apply(ServerResponse ctx) {
                    return this;
                }
            };
        }

        public static ByteRange singleByteRange(final long start, final long end, final long contentLength) {
            return new ByteRange(){

                @Override
                public long getStart() {
                    return start;
                }

                @Override
                public long getEnd() {
                    return end;
                }

                @Override
                public long getContentLength() {
                    return contentLength;
                }

                @Override
                public String getContentRange() {
                    return "bytes " + start + "-" + end + "/" + contentLength;
                }

                @Override
                public Status getStatusCode() {
                    return Status.PARTIAL_CONTENT;
                }

                @Override
                public ByteRange apply(ServerResponse ctx) {
                    ctx.header("Accept-Ranges", "bytes");
                    ctx.header("Content-Range", this.getContentRange());
                    ctx.header("Content-Length", Long.toString(contentLength));
                    ctx.statusCode(Status.PARTIAL_CONTENT.value());
                    return this;
                }
            };
        }
    }

    static class ChunkedStream
    implements IoCallback,
    Runnable {
        private ReadableByteChannel source;
        private HttpServerExchange exchange;
        private Sender sender;
        private PooledByteBuffer pooled;
        private IoCallback callback;
        private final long len;
        private long total;

        public ChunkedStream(long len) {
            this.len = len;
        }

        public void send(ReadableByteChannel source, HttpServerExchange exchange, IoCallback callback) {
            this.source = source;
            this.exchange = exchange;
            this.callback = callback;
            this.sender = exchange.getResponseSender();
            ServerConnection connection = exchange.getConnection();
            this.pooled = connection.getByteBufferPool().allocate();
            this.onComplete(exchange, this.sender);
        }

        @Override
        public void run() {
            ByteBuffer buffer = this.pooled.getBuffer();
            try {
                buffer.clear();
                int count = this.source.read(buffer);
                if (count == -1 || this.len != -1L && this.total >= this.len) {
                    this.done();
                    this.callback.onComplete(this.exchange, this.sender);
                } else {
                    this.total += (long)count;
                    buffer.flip();
                    if (this.len > 0L && this.total > this.len) {
                        long limit = (long)count - (this.total - this.len);
                        buffer.limit((int)limit);
                    }
                    this.sender.send(buffer, (IoCallback)this);
                }
            }
            catch (IOException ex) {
                this.onException(this.exchange, this.sender, ex);
            }
        }

        public void onComplete(HttpServerExchange exchange, Sender sender) {
            if (exchange.isInIoThread()) {
                exchange.dispatch((Runnable)this);
            } else {
                this.run();
            }
        }

        public void onException(HttpServerExchange exchange, Sender sender, IOException ex) {
            this.done();
            this.callback.onException(exchange, sender, ex);
        }

        private void done() {
            this.pooled.close();
            this.pooled = null;
            IoUtils.safeClose((Closeable)this.source);
        }
    }
}

