/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.javapla.jawn.core.Config;
import net.javapla.jawn.core.Context;
import net.javapla.jawn.core.Cookie;
import net.javapla.jawn.core.HttpMethod;
import net.javapla.jawn.core.MediaType;
import net.javapla.jawn.core.Up;
import net.javapla.jawn.core.server.FormItem;
import net.javapla.jawn.core.server.ServerRequest;
import net.javapla.jawn.core.server.WebSocket;
import net.javapla.jawn.core.util.MultiList;
import net.javapla.jawn.server.undertow.UndertowFormItem;
import net.javapla.jawn.server.undertow.UndertowWebSocket;

class UndertowRequest
implements ServerRequest {
    static final Path TMP_DIR = Paths.get(System.getProperty("java.io.tmpdir") + "/jawn", new String[0]);
    private final Config config;
    private final HttpServerExchange exchange;
    private final String path;
    private final HttpMethod method;
    private MultiList<FormItem> form;
    private MultiList<String> params;
    private MultiList<String> headers;

    public UndertowRequest(Config config, HttpServerExchange exchange) {
        this.config = config;
        this.exchange = exchange;
        this.path = exchange.getRequestPath();
        this.method = HttpMethod.getMethod((CharSequence)exchange.getRequestMethod().toString(), () -> this.formData());
    }

    public HttpMethod method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public String queryString() {
        return this.exchange.getQueryString();
    }

    public MultiList<String> queryParams() {
        if (this.params == null) {
            MultiList params = new MultiList();
            Map query = this.exchange.getQueryParameters();
            if (query != null) {
                query.entrySet().stream().forEach(entry -> params.put((String)entry.getKey(), (Collection)entry.getValue()));
            }
            this.params = params;
        }
        return this.params;
    }

    public MultiList<String> headers() {
        if (this.headers == null) {
            MultiList h = new MultiList();
            HeaderMap values = this.exchange.getRequestHeaders();
            for (HeaderValues header : values) {
                header.forEach(v -> h.put(header.getHeaderName().toString(), v));
            }
            this.headers = h;
        }
        return this.headers;
    }

    public List<Cookie> cookies() {
        return this.exchange.getRequestCookies().values().stream().map(UndertowRequest::cookie).collect(Collectors.toList());
    }

    public MultiList<FormItem> formData() {
        if (this.form == null) {
            MultiList list = new MultiList();
            FormData formData = this.parseForm();
            formData.forEach(name -> {
                System.out.println((String)name);
                System.out.println(formData.get(name).getFirst());
                formData.get(name).stream().forEach(value -> list.put(name, (Object)new UndertowFormItem((FormData.FormValue)value, (String)name)));
            });
            this.form = list;
        }
        return this.form;
    }

    public InputStream in() throws IOException {
        this.blocking();
        return this.exchange.getInputStream();
    }

    public String ip() {
        return Optional.ofNullable(this.exchange.getSourceAddress()).map(src -> Optional.ofNullable(src.getAddress()).map(InetAddress::getHostAddress).orElse("")).orElse("");
    }

    public String protocol() {
        return this.exchange.getProtocol().toString();
    }

    public String scheme() {
        return this.exchange.getRequestScheme();
    }

    public InetSocketAddress remoteAddress() {
        return this.exchange.getSourceAddress();
    }

    public void startAsync(Executor executor, Runnable runnable) {
        this.exchange.dispatch(executor, runnable);
    }

    boolean isInIoThread() {
        return this.exchange.isInIoThread();
    }

    Executor worker() {
        return this.exchange.getConnection().getWorker();
    }

    public void upgrade(Context.Request req, WebSocket.Initialiser initialiser) {
        try {
            Handlers.websocket((exchange, channel) -> {
                UndertowWebSocket ws = new UndertowWebSocket(this.config, this, channel);
                initialiser.init(req, (WebSocket.Listener)ws);
                ws.fireConnect();
            }).handleRequest(this.exchange);
        }
        catch (Exception e) {
            throw Up.IO.because((Throwable)e);
        }
    }

    private void blocking() {
        if (!this.exchange.isBlocking()) {
            this.exchange.startBlocking();
        }
    }

    private FormData parseForm() {
        FormData formData = (FormData)this.exchange.getAttachment(FormDataParser.FORM_DATA);
        if (formData == null) {
            formData = new FormData(0);
            try {
                String charset = StandardCharsets.UTF_8.name();
                String value = this.exchange.getRequestHeaders().getFirst("Content-Type");
                if (value != null) {
                    if (value.startsWith(MediaType.FORM.name())) {
                        this.blocking();
                        formData = new FormEncodedDataDefinition().setDefaultEncoding(charset).create(this.exchange).parseBlocking();
                    } else if (value.startsWith(MediaType.MULTIPART.name())) {
                        this.blocking();
                        formData = new MultiPartParserDefinition().setTempFileLocation(TMP_DIR).setDefaultEncoding(charset).create(this.exchange).parseBlocking();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return formData;
    }

    private static Cookie cookie(io.undertow.server.handlers.Cookie cookie) {
        Cookie.Builder bob = new Cookie.Builder(cookie.getName(), cookie.getValue());
        Optional.ofNullable(cookie.getComment()).ifPresent(arg_0 -> ((Cookie.Builder)bob).comment(arg_0));
        Optional.ofNullable(cookie.getDomain()).ifPresent(arg_0 -> ((Cookie.Builder)bob).domain(arg_0));
        Optional.ofNullable(cookie.getPath()).ifPresent(arg_0 -> ((Cookie.Builder)bob).path(arg_0));
        Optional.ofNullable(cookie.getVersion()).ifPresent(arg_0 -> ((Cookie.Builder)bob).version(arg_0));
        Optional.ofNullable(cookie.getMaxAge()).ifPresent(arg_0 -> ((Cookie.Builder)bob).maxAge(arg_0));
        bob.httpOnly(cookie.isHttpOnly());
        bob.secure(cookie.isSecure());
        return bob.build();
    }

    static {
        if (!TMP_DIR.toFile().exists()) {
            TMP_DIR.toFile().mkdirs();
        }
    }
}

