/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Protocols;
import java.nio.charset.StandardCharsets;
import net.javapla.jawn.core.Config;
import net.javapla.jawn.core.server.ServerRequest;
import net.javapla.jawn.core.server.ServerResponse;
import net.javapla.jawn.server.undertow.UndertowRequest;
import net.javapla.jawn.server.undertow.UndertowResponse;

class UndertowHandler
implements HttpHandler {
    private final Config config;
    private final net.javapla.jawn.core.server.HttpHandler dispatcher;
    private final FormParserFactory parserFactory;

    UndertowHandler(Config config, net.javapla.jawn.core.server.HttpHandler dispatcher) {
        this.config = config;
        this.dispatcher = dispatcher;
        this.parserFactory = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)new MultiPartParserDefinition(UndertowRequest.TMP_DIR).setDefaultEncoding(StandardCharsets.UTF_8.name())).addParser((FormParserFactory.ParserDefinition)new FormEncodedDataDefinition().setDefaultEncoding(StandardCharsets.UTF_8.name())).build();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            HeaderValues upgrade = exchange.getRequestHeaders().get(Headers.UPGRADE);
            if (upgrade != null && upgrade.contains((Object)"h2c")) {
                exchange.setProtocol(Protocols.HTTP_1_1);
            }
            exchange.dispatch((HttpHandler)this);
            return;
        }
        FormDataParser parser = this.parserFactory.createParser(exchange);
        if (parser != null) {
            parser.parse(this::handle);
        } else {
            this.handle(exchange);
        }
    }

    private final void handle(HttpServerExchange exchange) throws Exception {
        this.dispatcher.handle((ServerRequest)new UndertowRequest(this.config, exchange), (ServerResponse)new UndertowResponse(exchange));
    }
}

