/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.server.handlers.form.FormData;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import net.javapla.jawn.core.server.FormItem;
import net.javapla.jawn.core.util.MultiList;

final class UndertowFormItem
implements FormItem {
    private final FormData.FormValue value;
    private final String fieldName;

    UndertowFormItem(FormData.FormValue value, String fieldName) {
        if (value.isFileItem()) {
            System.out.println(value.getFileItem().getFile());
            System.out.println(value.getFileName());
        }
        this.value = value;
        this.fieldName = fieldName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Optional<String> value() {
        return !this.value.isFileItem() ? Optional.of(this.value.getValue()) : Optional.empty();
    }

    public Optional<Path> file() throws IOException {
        return this.value.isFileItem() ? Optional.of(this.value.getFileItem().getFile()) : Optional.empty();
    }

    public Optional<InputStream> stream() throws IOException {
        return this.value.isFileItem() ? Optional.of(this.value.getFileItem().getInputStream()) : Optional.empty();
    }

    public Optional<String> fileName() {
        return this.value.isFileItem() ? Optional.of(this.value.getFileName()) : Optional.empty();
    }

    public MultiList<String> headers() {
        MultiList h = new MultiList();
        HeaderMap values = this.value.getHeaders();
        if (values == null) {
            return h;
        }
        for (HeaderValues header : values) {
            header.forEach(v -> h.put(header.getHeaderName().toString(), v));
        }
        return h;
    }

    public String contentType() {
        return this.value.getHeaders().getFirst(HttpString.tryFromString((String)"Content-Type"));
    }

    public String toString() {
        return this.value().toString();
    }
}

