/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import com.google.inject.Inject;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import net.javapla.jawn.core.server.Server;
import net.javapla.jawn.core.server.ServerConfig;
import net.javapla.jawn.server.undertow.UndertowHandler;
import org.xnio.Options;

public class UndertowServer
implements Server {
    private final net.javapla.jawn.core.server.HttpHandler dispatcher;
    private Undertow server;
    private GracefulShutdownHandler shutdownHandler;

    @Inject
    public UndertowServer(net.javapla.jawn.core.server.HttpHandler dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void start(ServerConfig serverConfig) throws Exception {
        this.shutdownHandler = new GracefulShutdownHandler(UndertowServer.createHandler(this.dispatcher, serverConfig.contextPath()));
        Undertow.Builder builder = Undertow.builder().setHandler((HttpHandler)this.shutdownHandler).addHttpListener(serverConfig.port(), serverConfig.host()).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false).setServerOption(UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true).setServerOption(UndertowOptions.ALWAYS_SET_DATE, (Object)true).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)false);
        UndertowServer.configureServerPerformance(builder, serverConfig);
        this.server = builder.build();
        this.server.start();
    }

    public void stop() throws Exception {
        this.shutdownHandler.shutdown();
        this.shutdownHandler.awaitShutdown(5000L);
        this.server.stop();
    }

    public void join() throws InterruptedException {
    }

    private static final HttpHandler createHandler(net.javapla.jawn.core.server.HttpHandler dispatcher, String contextPath) {
        return new UndertowHandler(dispatcher, contextPath);
    }

    private static void configureServerPerformance(Undertow.Builder serverBuilder, ServerConfig config) {
        int workerThreads;
        int ioThreads;
        int undertow_minimum = 2;
        switch (config.serverPerformance()) {
            case HIGHEST: {
                ioThreads = Math.max(Runtime.getRuntime().availableProcessors() << 1, undertow_minimum);
                workerThreads = ioThreads * 8;
                serverBuilder.setBufferSize(16384);
                break;
            }
            case HIGH: {
                ioThreads = Math.max(Runtime.getRuntime().availableProcessors(), undertow_minimum);
                workerThreads = ioThreads * 8;
                break;
            }
            default: {
                ioThreads = Math.max(Runtime.getRuntime().availableProcessors() / 2, undertow_minimum);
                workerThreads = ioThreads * 4;
                break;
            }
            case LOW: {
                workerThreads = ioThreads = undertow_minimum;
                break;
            }
            case CUSTOM: {
                ioThreads = Math.max(config.ioThreads(), undertow_minimum);
                workerThreads = ioThreads * 8;
            }
        }
        serverBuilder.setIoThreads(ioThreads);
        serverBuilder.setWorkerThreads(workerThreads);
        serverBuilder.setSocketOption(Options.BACKLOG, (Object)config.backlog());
        serverBuilder.setSocketOption(Options.WORKER_IO_THREADS, (Object)ioThreads);
    }
}

