/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.javapla.jawn.core.http.Cookie;
import net.javapla.jawn.core.http.Response;
import org.xnio.IoUtils;

public class UndertowResponse
implements Response {
    private final HttpServerExchange exchange;
    private final Runnable blocking;
    private String contentType;
    private Optional<Charset> charset = Optional.empty();
    private boolean writerCreated = false;

    public UndertowResponse(HttpServerExchange exchange) {
        this.exchange = exchange;
        this.blocking = () -> {
            if (!this.exchange.isBlocking()) {
                this.exchange.startBlocking();
            }
        };
    }

    public Optional<String> header(String name) {
        String value = this.exchange.getResponseHeaders().getFirst(name);
        return Optional.ofNullable(value);
    }

    public List<String> headers(String name) {
        Objects.requireNonNull(name, "A header's name is required.");
        HeaderValues values = this.exchange.getResponseHeaders().get(name);
        return values == null ? Collections.emptyList() : values;
    }

    public void header(String name, List<String> values) {
        HeaderMap headers = this.exchange.getResponseHeaders();
        headers.putAll(new HttpString(name), Collections.unmodifiableList(values));
    }

    public void header(String name, String value) {
        this.exchange.getResponseHeaders().put(new HttpString(name), value);
    }

    public void send(byte[] bytes) throws Exception {
        this.send(ByteBuffer.wrap(bytes));
    }

    public void send(ByteBuffer buffer) throws Exception {
        this.exchange.getResponseSender().send(buffer);
    }

    public void send(InputStream stream) throws Exception {
        new ChunkedStream().send(Channels.newChannel(stream), this.exchange, IoCallback.END_EXCHANGE);
    }

    public void send(FileChannel channel) throws Exception {
        new ChunkedStream().send(channel, this.exchange, IoCallback.END_EXCHANGE);
    }

    public int statusCode() {
        return this.exchange.getStatusCode();
    }

    public void statusCode(int code) {
        this.exchange.setStatusCode(code);
    }

    public String contentType() {
        return this.contentType;
    }

    public void contentType(String contentType) {
        this.contentType = contentType;
        this.setContentType();
    }

    public void addCookie(Cookie cookie) {
        this.exchange.setResponseCookie(UndertowResponse.cookie(cookie));
    }

    public void characterEncoding(String encoding) {
        this.charset = Optional.ofNullable(Charset.forName(encoding));
        this.setContentType();
    }

    public Optional<Charset> characterEncoding() {
        return this.charset;
    }

    public Writer writer() {
        this.writerCreated = true;
        return new OutputStreamWriter(this.outputStream());
    }

    public OutputStream outputStream() {
        this.blocking.run();
        return this.exchange.getOutputStream();
    }

    public boolean usingWriter() {
        return this.writerCreated;
    }

    public boolean committed() {
        return this.exchange.isResponseStarted();
    }

    public void end() {
        this.exchange.endExchange();
    }

    public void reset() {
        this.exchange.getResponseHeaders().clear();
    }

    private void setContentType() {
        if (this.contentType != null) {
            this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.contentType + this.charset.map(ch -> "; charset=" + ch).orElse(""));
        }
    }

    private static io.undertow.server.handlers.Cookie cookie(Cookie cookie) {
        return new CookieImpl(cookie.getName(), cookie.getValue()).setComment(cookie.getComment()).setDomain(cookie.getDomain()).setPath(cookie.getPath()).setVersion(cookie.getVersion()).setMaxAge(Integer.valueOf(cookie.getMaxAge())).setHttpOnly(cookie.isHttpOnly()).setSecure(cookie.isSecure()).setExpires(cookie.getExpires());
    }

    static class ChunkedStream
    implements IoCallback,
    Runnable {
        private ReadableByteChannel source;
        private HttpServerExchange exchange;
        private Sender sender;
        private PooledByteBuffer pooled;
        private IoCallback callback;
        private int bufferSize;
        private int chunk;

        ChunkedStream() {
        }

        public void send(ReadableByteChannel source, HttpServerExchange exchange, IoCallback callback) {
            this.source = source;
            this.exchange = exchange;
            this.callback = callback;
            this.sender = exchange.getResponseSender();
            ServerConnection connection = exchange.getConnection();
            this.pooled = connection.getByteBufferPool().allocate();
            this.bufferSize = connection.getBufferSize();
            this.onComplete(exchange, this.sender);
        }

        @Override
        public void run() {
            ByteBuffer buffer = this.pooled.getBuffer();
            ++this.chunk;
            try {
                buffer.clear();
                int count = this.source.read(buffer);
                if (count == -1) {
                    this.done();
                    this.callback.onComplete(this.exchange, this.sender);
                } else {
                    if (this.chunk == 1) {
                        if (count < this.bufferSize) {
                            HeaderMap headers = this.exchange.getResponseHeaders();
                            if (!headers.contains(Headers.CONTENT_LENGTH)) {
                                headers.put(Headers.CONTENT_LENGTH, (long)count);
                                headers.remove(Headers.TRANSFER_ENCODING);
                            }
                        } else {
                            HeaderMap headers = this.exchange.getResponseHeaders();
                            if (!headers.contains(Headers.CONTENT_LENGTH)) {
                                headers.put(Headers.TRANSFER_ENCODING, "chunked");
                            }
                        }
                    }
                    buffer.flip();
                    this.sender.send(buffer, (IoCallback)this);
                }
            }
            catch (IOException ex) {
                this.onException(this.exchange, this.sender, ex);
            }
        }

        public void onComplete(HttpServerExchange exchange, Sender sender) {
            if (exchange.isInIoThread()) {
                exchange.dispatch((Runnable)this);
            } else {
                this.run();
            }
        }

        public void onException(HttpServerExchange exchange, Sender sender, IOException ex) {
            this.done();
            this.callback.onException(exchange, sender, ex);
        }

        private void done() {
            this.pooled.close();
            this.pooled = null;
            IoUtils.safeClose((Closeable)this.source);
        }
    }
}

