/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.javapla.jawn.core.http.Cookie;
import net.javapla.jawn.core.http.FormItem;
import net.javapla.jawn.core.http.HttpMethod;
import net.javapla.jawn.core.http.Request;
import net.javapla.jawn.core.util.MultiList;
import net.javapla.jawn.core.util.URLCodec;
import net.javapla.jawn.server.undertow.UndertowFormItem;

public class UndertowRequest
implements Request {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir") + "/jawn-test");
    private final HttpServerExchange exchange;
    private final String path;
    private final String contextPath;
    private final FormData form;
    private final Runnable blocking;

    public UndertowRequest(HttpServerExchange exchange, String contextPath) throws IOException {
        this.exchange = exchange;
        this.blocking = () -> {
            if (!this.exchange.isBlocking()) {
                this.exchange.startBlocking();
            }
        };
        this.form = this.parseForm(exchange, StandardCharsets.UTF_8.name());
        this.contextPath = contextPath;
        this.path = URLCodec.decode((String)UndertowRequest.stripContextPath(contextPath, exchange.getRequestPath()), (Charset)StandardCharsets.UTF_8);
    }

    public HttpMethod method() {
        return HttpMethod.getMethod((String)this.exchange.getRequestMethod().toString(), this.params());
    }

    public String path() {
        return this.path;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public String queryString() {
        return this.exchange.getQueryString();
    }

    public MultiList<String> params() {
        MultiList params = new MultiList();
        Map query = this.exchange.getQueryParameters();
        if (query != null) {
            query.entrySet().stream().forEach(entry -> params.put((String)entry.getKey(), (Collection)entry.getValue()));
        }
        this.form.forEach(element -> this.form.get(element).stream().filter(value -> !value.isFile()).forEach(value -> params.put(element, (Object[])new String[]{value.getValue()})));
        return params;
    }

    public List<String> params(String name) {
        ArrayList<String> list = new ArrayList<String>();
        Deque query = (Deque)this.exchange.getQueryParameters().get(name);
        if (query != null) {
            query.forEach(list::add);
        }
        Optional.ofNullable(this.form.get(name)).ifPresent(values -> values.forEach(value -> {
            if (!value.isFile()) {
                list.add(value.getValue());
            }
        }));
        return list;
    }

    public Optional<String> param(String name) {
        List<String> params = this.params(name);
        return params.stream().findFirst();
    }

    public List<FormItem> files() {
        ArrayList<FormItem> list = new ArrayList<FormItem>();
        this.form.forEach(fieldName -> this.form.get(fieldName).stream().forEach(value -> list.add(new UndertowFormItem((FormData.FormValue)value, (String)fieldName))));
        return list;
    }

    public List<String> headers(String name) {
        HeaderValues values = this.exchange.getRequestHeaders().get(name);
        return values == null ? Collections.emptyList() : values;
    }

    public Optional<String> header(String name) {
        return Optional.ofNullable(this.exchange.getRequestHeaders().getFirst(name));
    }

    public List<String> headerNames() {
        return this.exchange.getRequestHeaders().getHeaderNames().stream().map(HttpString::toString).collect(Collectors.toList());
    }

    public Map<String, Cookie> cookies() {
        Stream stream = this.exchange.getRequestCookies().entrySet().stream();
        return stream.collect(Collectors.toMap(Map.Entry::getKey, UndertowRequest::cookie));
    }

    public InputStream in() throws IOException {
        this.blocking.run();
        return this.exchange.getInputStream();
    }

    public byte[] bytes() throws IOException {
        try (InputStream stream = this.in();){
            ByteArrayOutputStream array = new ByteArrayOutputStream(stream.available());
            byte[] byArray = array.toByteArray();
            return byArray;
        }
    }

    public String ip() {
        return Optional.ofNullable(this.exchange.getSourceAddress()).map(src -> Optional.ofNullable(src.getAddress()).map(InetAddress::getHostAddress).orElse("")).orElse("");
    }

    public String protocol() {
        return this.exchange.getProtocol().toString();
    }

    public int port() {
        return this.exchange.getHostPort();
    }

    public String scheme() {
        return this.exchange.getRequestScheme();
    }

    public void startAsync() {
        this.exchange.dispatch();
    }

    private static final String stripContextPath(String contextPath, String requestPath) {
        return requestPath.substring(contextPath.length());
    }

    private FormData parseForm(HttpServerExchange exchange, String charset) throws IOException {
        String value = exchange.getRequestHeaders().getFirst("Content-Type");
        if (value != null) {
            if (value.startsWith("application/x-www-form-urlencoded")) {
                this.blocking.run();
                return new FormEncodedDataDefinition().setDefaultEncoding(charset).create(exchange).parseBlocking();
            }
            if (value.startsWith("multipart/form-data")) {
                this.blocking.run();
                return new MultiPartParserDefinition().setTempFileLocation(TMP_DIR.toPath()).setDefaultEncoding(charset).create(exchange).parseBlocking();
            }
        }
        return new FormData(0);
    }

    public static <T> Supplier<T> memoizeLock(Supplier<T> delegate) {
        AtomicReference value = new AtomicReference();
        return () -> {
            Object val = value.get();
            if (val == null) {
                AtomicReference atomicReference = value;
                synchronized (atomicReference) {
                    val = value.get();
                    if (val == null) {
                        val = Objects.requireNonNull(delegate.get());
                        value.set(val);
                    }
                }
            }
            return val;
        };
    }

    private static Cookie cookie(io.undertow.server.handlers.Cookie cookie) {
        Cookie.Builder bob = Cookie.builder((String)cookie.getName(), (String)cookie.getValue());
        Optional.ofNullable(cookie.getComment()).ifPresent(arg_0 -> ((Cookie.Builder)bob).setComment(arg_0));
        Optional.ofNullable(cookie.getDomain()).ifPresent(arg_0 -> ((Cookie.Builder)bob).setDomain(arg_0));
        Optional.ofNullable(cookie.getPath()).ifPresent(arg_0 -> ((Cookie.Builder)bob).setPath(arg_0));
        Optional.ofNullable(cookie.getVersion()).ifPresent(arg_0 -> ((Cookie.Builder)bob).setVersion(arg_0));
        Optional.ofNullable(cookie.getMaxAge()).ifPresent(arg_0 -> ((Cookie.Builder)bob).setMaxAge(arg_0));
        Optional.ofNullable(cookie.getExpires()).ifPresent(arg_0 -> ((Cookie.Builder)bob).setExpires(arg_0));
        bob.setHttpOnly(cookie.isHttpOnly());
        bob.setSecure(cookie.isSecure());
        return bob.build();
    }

    private static Cookie cookie(Map.Entry<String, io.undertow.server.handlers.Cookie> cookieEntry) {
        return UndertowRequest.cookie(cookieEntry.getValue());
    }

    static {
        if (!TMP_DIR.exists()) {
            TMP_DIR.mkdir();
        }
    }

    static class MemoizingSupplier<T>
    implements Supplier<T> {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            return "Suppliers.memoize(" + this.delegate + ")";
        }
    }
}

