/*
 * Decompiled with CFR 0.152.
 */
package net.javapla.jawn.server.undertow;

import io.undertow.server.handlers.form.FormData;
import io.undertow.util.HttpString;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.javapla.jawn.core.http.FormItem;

public class UndertowFormItem
implements FormItem {
    private final FormData.FormValue value;
    private final String fieldName;

    public UndertowFormItem(FormData.FormValue value, String fieldName) {
        this.value = value;
        this.fieldName = fieldName;
    }

    public String getValue() {
        if (this.isFile()) {
            return this.value.getFileName();
        }
        return this.value.getValue();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isFile() {
        return this.value.isFile();
    }

    public String getContentType() {
        return this.value.getHeaders().getFirst(HttpString.tryFromString((String)"Content-Type"));
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this.value.getPath().toFile());
    }

    public String toString() {
        return this.getValue();
    }
}

