/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.key.console;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Console;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.key.spec.KeyPromptingDisabledException;
import net.java.truevfs.key.spec.PromptingKeyProvider;
import net.java.truevfs.key.spec.SafeKey;
import net.java.truevfs.key.spec.param.KeyStrength;
import net.java.truevfs.key.spec.param.SafePbeParameters;
import net.java.truevfs.key.spec.param.SafePbeParametersView;

@ThreadSafe
abstract class ConsoleSafePbeParametersView<P extends SafePbeParameters<P, S>, S extends KeyStrength>
extends SafePbeParametersView<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(ConsoleSafePbeParametersView.class.getName());
    private static final Object lock = new Object();
    private static final int MIN_PASSWD_LEN = 8;
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private static URI lastResource = URI.create("");
    private static final String YES = resources.getString("yes");
    private static final String NO = resources.getString("no");

    ConsoleSafePbeParametersView() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void promptWriteKey(PromptingKeyProvider.Controller<P> controller) throws KeyPromptingDisabledException {
        Console con = System.console();
        if (null == con) {
            throw new KeyPromptingDisabledException();
        }
        Object object = lock;
        synchronized (object) {
            String input;
            URI resource = controller.getResource();
            assert (null != resource);
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("writeKey.banner"), resource);
            }
            lastResource = resource;
            SafePbeParameters param = (SafePbeParameters)controller.getKey();
            if (null == param) {
                param = this.newPbeParameters();
            }
            while (true) {
                char[] input1;
                if (null == (input1 = con.readPassword(resources.getString("writeKey.newPasswd1"), new Object[0])) || 0 >= input1.length) {
                    return;
                }
                if (8 > input1.length) {
                    con.printf(resources.getString("writeKey.passwd.tooShort"), 8);
                    continue;
                }
                try {
                    char[] input2;
                    block26: {
                        input2 = con.readPassword(resources.getString("writeKey.newPasswd2"), new Object[0]);
                        if (input2 == null) {
                            return;
                        }
                        try {
                            if (Arrays.equals(input1, input2)) break block26;
                            con.printf(resources.getString("writeKey.passwd.noMatch"), new Object[0]);
                        }
                        catch (Throwable throwable) {
                            Arrays.fill(input2, '\u0000');
                            throw throwable;
                        }
                        Arrays.fill(input2, '\u0000');
                        continue;
                    }
                    param.setPassword(input1);
                    Arrays.fill(input2, '\u0000');
                }
                finally {
                    Arrays.fill(input1, '\u0000');
                    continue;
                }
                break;
            }
            con.printf(resources.getString("keyStrength.banner"), new Object[0]);
            StringBuilder builder = new StringBuilder();
            KeyStrength[] array = param.getKeyStrengthValues();
            HashMap<Integer, KeyStrength> map = new HashMap<Integer, KeyStrength>(array.length / 3 * 4 + 1);
            PrintWriter writer = con.writer();
            for (KeyStrength strength : array) {
                if (0 < builder.length()) {
                    builder.append('/');
                }
                builder.append(strength.getBits());
                map.put(strength.getBits(), strength);
                writer.println(strength);
            }
            String selection = builder.toString();
            while (null != (input = con.readLine(resources.getString("keyStrength.prompt"), selection, param.getKeyStrength().getBits())) && input.length() > 0) {
                try {
                    int bits = Integer.parseInt(input);
                    KeyStrength strength = (KeyStrength)map.get(bits);
                    if (null == strength) continue;
                    assert (strength.getBits() == bits);
                    param.setKeyStrength(strength);
                    break;
                }
                catch (NumberFormatException ex) {
                }
            }
            controller.setKey((SafeKey)param);
        }
    }

    public void promptReadKey(PromptingKeyProvider.Controller<P> controller, boolean invalid) throws KeyPromptingDisabledException {
        Console con = System.console();
        if (null == con) {
            throw new KeyPromptingDisabledException();
        }
        Object object = lock;
        synchronized (object) {
            String changeKey;
            if (invalid) {
                con.printf(resources.getString("readKey.invalid"), new Object[0]);
            }
            URI resource = controller.getResource();
            assert (null != resource);
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("readKey.banner"), resource);
            }
            lastResource = resource;
            char[] passwd = con.readPassword(resources.getString("readKey.passwd"), new Object[0]);
            if (null == passwd || passwd.length <= 0) {
                controller.setKey(null);
                return;
            }
            SafePbeParameters param = this.newPbeParameters();
            param.setPassword(passwd);
            Arrays.fill(passwd, '\u0000');
            controller.setKey((SafeKey)param);
            do {
                changeKey = con.readLine(resources.getString("readKey.change"), new Object[0]);
                controller.setChangeRequested(YES.equalsIgnoreCase(changeKey));
            } while (null != changeKey && changeKey.length() > 0 && !YES.equalsIgnoreCase(changeKey) && !NO.equalsIgnoreCase(changeKey));
            return;
        }
    }
}

