/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.sample;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoSockets;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.services.Container;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsControllerSyncVisitor;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsSimpleCompositeDriver;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.FsUriModifier;
import net.java.truevfs.kernel.spec.sl.FsDriverMapLocator;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;

public final class Copy {
    private Copy() {
    }

    public static void main(String[] args) throws IOException {
        Copy.copy(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(String src, String dst) throws IOException {
        FsManager manager = FsManagerLocator.SINGLETON.get();
        try {
            FsSimpleCompositeDriver driver = new FsSimpleCompositeDriver((Container)FsDriverMapLocator.SINGLETON);
            URI srcUri = URI.create(src);
            srcUri = srcUri.isAbsolute() ? srcUri : new File(src).toURI();
            FsNodePath srcPath = FsNodePath.create((URI)srcUri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            InputSocket srcSocket = manager.controller((FsCompositeDriver)driver, srcPath.getMountPoint()).input(FsAccessOptions.NONE, srcPath.getNodeName());
            URI dstUri = URI.create(dst);
            dstUri = dstUri.isAbsolute() ? dstUri : new File(dst).toURI();
            FsNodePath dstPath = FsNodePath.create((URI)dstUri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            OutputSocket dstSocket = manager.controller((FsCompositeDriver)driver, dstPath.getMountPoint()).output(BitField.of((Enum)FsAccessOption.CREATE_PARENTS, (Enum[])new FsAccessOption[]{FsAccessOption.EXCLUSIVE}), dstPath.getNodeName(), srcSocket.target());
            IoSockets.copy((InputSocket)srcSocket, (OutputSocket)dstSocket);
        }
        finally {
            manager.sync(Filter.ACCEPT_ANY, (Visitor)new FsControllerSyncVisitor(FsSyncOptions.UMOUNT));
        }
    }
}

