/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.sample;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.io.Streams;
import net.java.truecommons.services.Container;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsControllerSyncVisitor;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsSimpleCompositeDriver;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.FsUriModifier;
import net.java.truevfs.kernel.spec.sl.FsDriverMapLocator;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;

public final class Cat {
    private Cat() {
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        for (String path : args) {
            Cat.cat(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cat(String resource) throws IOException, URISyntaxException {
        FsManager manager = FsManagerLocator.SINGLETON.get();
        try {
            FsSimpleCompositeDriver driver = new FsSimpleCompositeDriver((Container)FsDriverMapLocator.SINGLETON);
            URI uri = new URI(resource);
            uri = uri.isAbsolute() ? uri : new File(resource).toURI();
            FsNodePath path = FsNodePath.create((URI)uri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            InputSocket socket = manager.controller((FsCompositeDriver)driver, path.getMountPoint()).input(BitField.noneOf(FsAccessOption.class), path.getNodeName());
            try (InputStream in = socket.stream(null);){
                Streams.cat((InputStream)in, (OutputStream)System.out);
            }
        }
        finally {
            manager.sync(Filter.ACCEPT_ANY, (Visitor)new FsControllerSyncVisitor(FsSyncOptions.UMOUNT));
        }
    }
}

