/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.io;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingInputStream;
import net.java.truevfs.kernel.spec.FsTestConfig;
import net.java.truevfs.kernel.spec.FsThrowManager;

@NotThreadSafe
public final class ThrowingInputStream
extends DecoratingInputStream {
    private final FsThrowManager control;

    @CreatesObligation
    public ThrowingInputStream(@WillCloseWhenClosed InputStream in) {
        this(in, null);
    }

    @CreatesObligation
    public ThrowingInputStream(@WillCloseWhenClosed InputStream in, @CheckForNull FsThrowManager control) {
        super(in);
        this.control = null != control ? control : FsTestConfig.get().getThrowControl();
    }

    private void checkAllExceptions() throws IOException {
        this.control.check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.control.check((Object)this, RuntimeException.class);
        this.control.check((Object)this, Error.class);
    }

    public int read() throws IOException {
        this.checkAllExceptions();
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkAllExceptions();
        return this.in.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        this.checkAllExceptions();
        return this.in.skip(n);
    }

    public int available() throws IOException {
        this.checkAllExceptions();
        return this.in.available();
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        this.in.close();
    }

    public void mark(int readlimit) {
        this.checkUndeclaredExceptions();
        this.in.mark(readlimit);
    }

    public void reset() throws IOException {
        this.checkAllExceptions();
        this.in.reset();
    }

    public boolean markSupported() {
        this.checkUndeclaredExceptions();
        return this.in.markSupported();
    }
}

