/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.cio;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.cio.DecoratingInputService;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.InputSocket;
import net.java.truevfs.kernel.spec.FsTestConfig;
import net.java.truevfs.kernel.spec.FsThrowManager;

@ThreadSafe
public class ThrowingInputService<E extends Entry>
extends DecoratingInputService<E> {
    private final FsTestConfig config;
    @CheckForNull
    private volatile FsThrowManager control;

    public ThrowingInputService(@WillCloseWhenClosed InputService<E> service) {
        this(service, null);
    }

    public ThrowingInputService(@WillCloseWhenClosed InputService<E> service, @CheckForNull FsTestConfig config) {
        super(service);
        this.config = null != config ? config : FsTestConfig.get();
    }

    private FsThrowManager getThrowControl() {
        FsThrowManager control = this.control;
        return null != control ? control : (this.control = this.config.getThrowControl());
    }

    private void checkAllExceptions() throws IOException {
        this.getThrowControl().check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.getThrowControl().check((Object)this, RuntimeException.class);
        this.getThrowControl().check((Object)this, Error.class);
    }

    public int size() {
        this.checkUndeclaredExceptions();
        return ((InputService)this.container).size();
    }

    public Iterator<E> iterator() {
        this.checkUndeclaredExceptions();
        return ((InputService)this.container).iterator();
    }

    public E entry(String name) {
        this.checkUndeclaredExceptions();
        return (E)((InputService)this.container).entry(name);
    }

    @DischargesObligation
    public void close() throws IOException {
        this.checkAllExceptions();
        ((InputService)this.container).close();
    }

    public InputSocket<E> input(String name) {
        this.checkUndeclaredExceptions();
        return ((InputService)this.container).input(name);
    }
}

