/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.cio;

import java.io.IOException;
import java.util.Iterator;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.MutableEntry;
import net.java.truecommons.cio.OutputSocket;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.mock.MockArchive;
import net.java.truevfs.kernel.spec.mock.MockArchiveDriverEntry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiplexingOutputServiceTest {
    private final MockArchive archive = MockArchive.create(null);
    private final MultiplexingOutputService<MockArchiveDriverEntry> service = new MultiplexingOutputService(this.archive.getPool(), this.archive.newOutputService());

    @Test
    public void testMultiplexing() throws IOException {
        String[] names;
        Assert.assertThat((Object)this.service.isBusy(), (Matcher)CoreMatchers.is((Object)false));
        for (String name : names = new String[]{"foo", "bar", "baz"}) {
            OutputSocket socket = this.service.output((MutableEntry)new MockArchiveDriverEntry(name, Entry.Type.FILE));
            Assert.assertThat((Object)this.service.entry(name), (Matcher)CoreMatchers.nullValue());
            socket.stream(null);
            Assert.assertThat((Object)this.service.entry(name), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.service.isBusy(), (Matcher)CoreMatchers.is((Object)true));
        }
        Assert.assertThat((Object)this.service.size(), (Matcher)CoreMatchers.is((Object)names.length));
        Iterator it = this.service.iterator();
        for (String name : names) {
            Assert.assertThat((Object)((MockArchiveDriverEntry)it.next()).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        }
    }
}

