/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.MemoryBufferPool;
import net.java.truecommons.shed.InheritableThreadLocalStack;
import net.java.truecommons.shed.Resource;
import net.java.truevfs.kernel.spec.FsThrowManager;

@CleanupObligation
@ThreadSafe
public final class FsTestConfig
extends Resource<IllegalStateException> {
    public static final int DEFAULT_NUM_ENTRIES = 10;
    public static final int DEFAULT_DATA_LENGTH = 1024;
    private static final InheritableThreadLocalStack<FsTestConfig> configs = new InheritableThreadLocalStack();
    private static final FsTestConfig GLOBAL = new FsTestConfig();
    private final FsThrowManager throwControl;
    private int numEmtries = 10;
    private int dataSize = 1024;
    private IoBufferPool pool;

    public static FsTestConfig get() {
        return (FsTestConfig)((Object)configs.peekOrElse((Object)GLOBAL));
    }

    @CreatesObligation
    public static FsTestConfig push() {
        return (FsTestConfig)((Object)configs.push((Object)new FsTestConfig(FsTestConfig.get())));
    }

    public static void pop() {
        configs.popIf((Object)FsTestConfig.get());
    }

    private FsTestConfig() {
        this.throwControl = new FsThrowManager();
    }

    private FsTestConfig(FsTestConfig template) {
        this.throwControl = new FsThrowManager(template.getThrowControl());
        this.numEmtries = template.getNumEntries();
        this.dataSize = template.getDataSize();
        this.pool = template.getPool();
    }

    public FsThrowManager getThrowControl() {
        return this.throwControl;
    }

    public int getNumEntries() {
        return this.numEmtries;
    }

    public void setNumEntries(int numEntries) {
        if (0 > numEntries) {
            throw new IllegalArgumentException();
        }
        this.numEmtries = numEntries;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int size) {
        if (0 > size) {
            throw new IllegalArgumentException();
        }
        this.dataSize = size;
    }

    public IoBufferPool getPool() {
        IoBufferPool pool = this.pool;
        return null != pool ? pool : (this.pool = new MemoryBufferPool(this.getDataSize()));
    }

    public void setPool(@CheckForNull IoBufferPool pool) {
        this.pool = pool;
    }

    @DischargesObligation
    public void close() throws IllegalStateException {
        super.close();
    }

    protected void onBeforeClose() throws IllegalStateException {
        configs.popIf((Object)this);
    }
}

