/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsUriModifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsNodePathTest {
    private static final Logger logger = LoggerFactory.getLogger(FsNodePathTest.class);

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"zip:zip:file:/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r"}, {"zip:file:/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r"}, {"file:/f\u00f6\u00f6%20b\u00e4r/f\u00f6\u00f6%20b\u00e4r"}, {"zip:file:/foo!/bar"}, {"file:/foo/bar"}, {"file:/foo/bar"}, {"f\u00f6\u00f6%20b\u00e4r"}, {"f\u00f6\u00f6/b\u00e4r"}, {"f\u00f6\u00f6"}, {"f\u00f6\u00f6?b\u00e4r"}, {""}}) {
            Object clone;
            FsNodePath original = FsNodePath.create((URI)URI.create(params[0]));
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(original);
            }
            logger.trace("Number of serialized bytes: {}", (Object)bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                clone = ois.readObject();
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            clone = null;
            try {
                enc.setExceptionListener(listener);
                enc.writeObject(original);
            }
            catch (Throwable x2) {
                clone = x2;
                throw x2;
            }
            finally {
                if (enc != null) {
                    if (clone != null) {
                        try {
                            enc.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)clone).addSuppressed(x2);
                        }
                    } else {
                        enc.close();
                    }
                }
            }
            logger.trace("XML String: {}", (Object)bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            var11_15 = null;
            try (XMLDecoder dec = new XMLDecoder(bis);){
                clone = dec.readObject();
            }
            catch (Throwable throwable) {
                var11_15 = throwable;
                throw throwable;
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() throws URISyntaxException {
        try {
            FsNodePath.create((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsNodePath((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsNodePath.create((URI)null, (FsUriModifier)FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsNodePath((URI)null, FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsNodePath.create((URI)null, (FsUriModifier)FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsNodePath((URI)null, FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsNodePath((FsMountPoint)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        for (String param : new String[]{"/../foo#boo", "/../foo#", "/../foo", "/./foo", "//foo", "/foo", "/foo/bar", "/foo/bar/", "/", "foo#fragmentDefined", "foo/", "foo//", "foo/.", "foo/./", "foo/..", "foo/../", "foo:/bar/.", "foo:/bar/..", "foo:bar", "foo:bar:", "foo:bar:/", "foo:bar:/baz", "foo:bar:/baz!", "foo:bar:/baz/", "foo:bar:/baz!//", "foo:bar:/baz!/.", "foo:bar:/baz!/./", "foo:bar:/baz!/..", "foo:bar:/baz!/../", "foo:bar:/baz!/bang/.", "foo:bar:/baz!/bang/./", "foo:bar:/baz!/bang/..", "foo:bar:/baz!/bang/../", "foo:bar:baz:/bang", "foo:bar:baz:/bang!", "foo:bar:baz:/bang/", "foo:bar:baz:/bang!/", "foo:bar:baz:/bang!/boom", "foo:bar:/baz/.!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "foo:bar:/baz/../!/bang/", "foo:bar:/baz/..!/bang/", "foo:bar:/baz/./!/bang/", "foo:bar:/baz/.!/bang/", "foo:bar:/../baz/!/bang/", "foo:bar:/./baz/!/bang/", "foo:bar://baz/!/bang/", "foo:bar://baz!/bang/", "foo:bar:/!/bang/", "foo:bar:/baz/../!/bang", "foo:bar:/baz/..!/bang", "foo:bar:/baz/./!/bang", "foo:bar:/baz/.!/bang", "foo:bar:/../baz/!/bang", "foo:bar:/./baz/!/bang", "foo:bar://baz/!/bang", "foo:bar://baz!/bang", "foo:bar:/!/bang", "foo:bar:/baz/!/", "foo:bar:/baz/?bang!/?plonk", "foo:bar:/baz//!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "//authority/defined"}) {
            URI uri = URI.create(param);
            try {
                FsNodePath.create((URI)uri);
                Assert.fail((String)param);
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                new FsNodePath(uri);
                Assert.fail((String)param);
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructorWithValidUri() {
        for (String[] params : new String[][]{{"foo:bar:baz:/b\u00e4%20ng!/b\u00f6%20\u00f6m!/pl\u00f6%20nk", "foo:bar:baz:/b\u00e4%20ng!/b\u00f6%20\u00f6m!/", "pl\u00f6%20nk"}, {"foo:bar:baz:/b\u00e4ng!/b\u00f6\u00f6m!/pl\u00f6nk", "foo:bar:baz:/b\u00e4ng!/b\u00f6\u00f6m!/", "pl\u00f6nk"}, {"foo:bar:baz:/bang!/boom!/plonk", "foo:bar:baz:/bang!/boom!/", "plonk"}, {"foo:bar:baz:/bang!/boom!/", "foo:bar:baz:/bang!/boom!/", ""}, {"foo:bar:/baz!/bang/../", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/bang/..", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/bang", "foo:bar:/baz!/", "bang"}, {"foo:bar:/baz!/./", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/.", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/", "foo:bar:/baz!/", ""}, {"foo:bar:/baz?bang!/?plonk", "foo:bar:/baz?bang!/", "?plonk"}, {"foo:bar:/baz!/bang/..", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/bang/../", "foo:bar:/baz!/", ""}, {"", null, ""}, {"foo", null, "foo"}, {"foo/..", null, ""}, {"foo/../", null, ""}, {"foo/bar", null, "foo/bar"}, {"foo:/", "foo:/", ""}, {"foo:/bar", "foo:/", "bar"}, {"foo:/bar/", "foo:/", "bar"}, {"foo:/bar//", "foo:/", "bar"}, {"foo:/bar/.", "foo:/", "bar"}, {"foo:/bar/./", "foo:/", "bar"}, {"foo:/bar/..", "foo:/", ""}, {"foo:/bar/../", "foo:/", ""}, {"foo:/bar/baz", "foo:/bar/", "baz"}, {"foo:/bar/baz?bang", "foo:/bar/", "baz?bang"}, {"foo:/bar/baz/", "foo:/bar/", "baz"}, {"foo:/bar/baz/?bang", "foo:/bar/", "baz?bang"}, {"file:////host/share/file", "file://host/share/", "file"}, {"file://host/share/file", "file://host/share/", "file"}, {"file:///foo/c%3A//", "file:/foo/", "c%3A"}, {"file:/foo/c%3A//", "file:/foo/", "c%3A"}, {"file:///c://", "file:/c:/", ""}, {"file:/c://", "file:/c:/", ""}, {"file:/c%3A", "file:/", "c%3A"}, {"f\u00f6\u00f6/", null, "f\u00f6\u00f6"}, {"/f\u00f6\u00f6", null, "f\u00f6\u00f6"}, {"///f\u00f6\u00f6", null, "f\u00f6\u00f6"}, {"////f\u00f6\u00f6", null, "f\u00f6\u00f6"}, {"/f\u00f6\u00f6/", null, "f\u00f6\u00f6"}, {"/C%3A/", null, "C%3A"}, {"C%3A/", null, "C%3A"}}) {
            FsNodePath path = FsNodePath.create((URI)URI.create(params[0]), (FsUriModifier)FsUriModifier.CANONICALIZE);
            FsMountPoint mountPoint = null == params[1] ? null : FsMountPoint.create((URI)URI.create(params[1]));
            FsNodeName entryName = FsNodeName.create((URI)URI.create(params[2]));
            this.assertPath(path, mountPoint, entryName);
            path = new FsNodePath(mountPoint, entryName);
            this.assertPath(path, mountPoint, entryName);
        }
    }

    private void assertPath(FsNodePath path, FsMountPoint mountPoint, FsNodeName entryName) {
        if (null != mountPoint) {
            Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
        } else {
            Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.nullValue());
        }
        Assert.assertThat((Object)path.getNodeName(), (Matcher)CoreMatchers.equalTo((Object)entryName));
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)path.getUri().toString()));
        Assert.assertThat((Object)FsNodePath.create((URI)path.getUri()), (Matcher)CoreMatchers.equalTo((Object)path));
        Assert.assertThat((Object)FsNodePath.create((URI)path.getUri()).hashCode(), (Matcher)CoreMatchers.equalTo((Object)path.hashCode()));
    }

    @Test
    public void testSpaces() {
        for (String[] params : new String[][]{{"foo:bar:baz:/%20!/%20/%20!/%20/%20", " ", " / ", " / "}, {"foo:bar:baz:/%20a%20!/%20b%20!/%20c%20", " a ", " b ", " c "}}) {
            FsNodePath path = FsNodePath.create((URI)URI.create(params[0]));
            int i = params.length;
            while (0 < --i) {
                Assert.assertThat((Object)path.getNodeName().getPath(), (Matcher)CoreMatchers.equalTo((Object)params[i]));
                path = path.getMountPoint().getPath();
            }
        }
    }

    @Test
    public void testHierarchicalize() {
        for (String[] params : new String[][]{{"foo:bar:baz:/x/b\u00f6%20m?pl\u00f6%20k!/b\u00e4%20g?z\u00f6%20k!/", "baz:/x/b\u00f6%20m/b\u00e4%20g?z\u00f6%20k"}, {"bar:baz:/x/b\u00f6%20m?pl\u00f6%20k!/b\u00e4%20g?z\u00f6%20k", "baz:/x/b\u00f6%20m/b\u00e4%20g?z\u00f6%20k"}, {"foo:bar:baz:/x/b\u00f6\u00f6m?pl\u00f6nk!/b\u00e4ng?z\u00f6nk!/", "baz:/x/b\u00f6\u00f6m/b\u00e4ng?z\u00f6nk"}, {"bar:baz:/x/b\u00f6\u00f6m?pl\u00f6nk!/b\u00e4ng?z\u00f6nk", "baz:/x/b\u00f6\u00f6m/b\u00e4ng?z\u00f6nk"}, {"foo:bar:baz:/boom?plonk!/bang?zonk!/", "baz:/boom/bang?zonk"}, {"bar:baz:/boom?plonk!/bang?zonk", "baz:/boom/bang?zonk"}, {"bar:baz:/boom?plonk!/?zonk", "baz:/boom/?zonk"}, {"bar:baz:/boom?plonk!/bang", "baz:/boom/bang"}, {"bar:baz:/boom?plonk!/", "baz:/boom?plonk"}, {"foo:bar:baz:/boom!/bang!/", "baz:/boom/bang"}, {"bar:baz:/boom!/bang", "baz:/boom/bang"}, {"foo:bar:/baz?boom!/", "bar:/baz?boom"}, {"bar:/baz?boom", "bar:/baz?boom"}, {"foo:bar:/baz!/", "bar:/baz"}, {"bar:/baz", "bar:/baz"}, {"foo:/bar/?boom", "foo:/bar/?boom"}, {"bar?boom", "bar?boom"}, {"foo:/bar/", "foo:/bar/"}, {"bar", "bar"}}) {
            FsNodePath path = FsNodePath.create((URI)URI.create(params[0]));
            URI hierarchical = path.toHierarchicalUri();
            Assert.assertThat((Object)hierarchical, (Matcher)CoreMatchers.equalTo((Object)URI.create(params[1])));
        }
    }
}

