/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsUriModifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsNodeNameTest {
    private static final Logger logger = LoggerFactory.getLogger(FsNodeNameTest.class);

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"f\u00f6\u00f6%20b\u00e4r"}, {"f\u00f6\u00f6/b\u00e4r"}, {"f\u00f6\u00f6"}, {"f\u00f6\u00f6?b\u00e4r"}, {""}}) {
            FsNodeName original = FsNodeName.create((URI)URI.create(params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(original);
            }
            logger.trace("Number of serialized bytes: {}", (Object)bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            Object ois = new ObjectInputStream(bis);
            Object clone = ((ObjectInputStream)ois).readObject();
            ((ObjectInputStream)ois).close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            ois = null;
            try {
                enc.setExceptionListener(listener);
                enc.writeObject(original);
            }
            catch (Throwable x2) {
                ois = x2;
                throw x2;
            }
            finally {
                if (enc != null) {
                    if (ois != null) {
                        try {
                            enc.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)ois).addSuppressed(x2);
                        }
                    } else {
                        enc.close();
                    }
                }
            }
            logger.trace("XML String: {}", (Object)bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder dec = new XMLDecoder(bis);
            clone = dec.readObject();
            dec.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() {
        for (String param : new String[]{"/../foo#boo", "/../foo#", "/../foo", "/./foo", "//foo", "/foo", "/foo/bar", "/foo/bar/", "/", "foo#fragmentDefined", "foo/", "foo//", "foo/.", "foo/./", "foo/..", "foo/../", "foo:bar", "foo:bar:", "foo:bar:/", "foo:bar:/baz", "foo:bar:/baz!", "foo:bar:/baz/", "foo:bar:/baz!//", "foo:bar:/baz!/#", "foo:bar:/baz!/#bang", "foo:bar:/baz!/.", "foo:bar:/baz!/./", "foo:bar:/baz!/..", "foo:bar:/baz!/../", "foo:bar:/baz!/bang/.", "foo:bar:/baz!/bang/./", "foo:bar:/baz!/bang/..", "foo:bar:/baz!/bang/../", "foo:bar:baz:/bang", "foo:bar:baz:/bang!", "foo:bar:baz:/bang/", "foo:bar:baz:/bang!/", "foo:bar:baz:/bang!/boom", "foo:bar:/baz/.!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "foo:bar:/baz/../!/bang/", "foo:bar:/baz/..!/bang/", "foo:bar:/baz/./!/bang/", "foo:bar:/baz/.!/bang/", "foo:bar:/../baz/!/bang/", "foo:bar:/./baz/!/bang/", "foo:bar://baz/!/bang/", "foo:bar://baz!/bang/", "foo:bar:/!/bang/", "foo:bar:/baz/../!/bang", "foo:bar:/baz/..!/bang", "foo:bar:/baz/./!/bang", "foo:bar:/baz/.!/bang", "foo:bar:/../baz/!/bang", "foo:bar:/./baz/!/bang", "foo:bar://baz/!/bang", "foo:bar://baz!/bang", "foo:bar:/!/bang", "foo:bar:/baz/!/", "foo:bar:/baz/?bang!/?plonk", "foo:bar:/baz//!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "//authority/defined"}) {
            URI uri = URI.create(param);
            try {
                FsNodeName.create((URI)uri);
                Assert.fail((String)param);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            try {
                new FsNodeName(uri);
                Assert.fail((String)param);
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructorWithValidUri() {
        for (String[] params : new String[][]{{"foo%3Abar", "baz", "foo%3Abar/baz"}, {"foo", "bar%3Abaz", "foo/bar%3Abaz"}, {"foo", "", "foo"}, {"", "", ""}, {"f\u00f6\u00f6", "?b\u00e4r", "f\u00f6\u00f6?b\u00e4r"}, {"f\u00f6\u00f6?b\u00e4r", "", "f\u00f6\u00f6"}, {"f\u00f6\u00f6?b\u00e4r", "?t\u00e4scht", "f\u00f6\u00f6?t\u00e4scht"}, {"f\u00f6\u00f6", "", "f\u00f6\u00f6"}, {"", "f\u00f6\u00f6", "f\u00f6\u00f6"}, {"f\u00f6\u00f6", "b\u00e4r", "f\u00f6\u00f6/b\u00e4r"}}) {
            FsNodeName parent = FsNodeName.create((URI)URI.create(params[0]));
            FsNodeName member = FsNodeName.create((URI)URI.create(params[1]));
            FsNodeName result = new FsNodeName(parent, member);
            Assert.assertThat((Object)result.getUri(), (Matcher)CoreMatchers.equalTo((Object)URI.create(params[2])));
            Assert.assertThat((Object)FsNodeName.create((URI)result.getUri()), (Matcher)CoreMatchers.equalTo((Object)result));
        }
    }

    @Test
    public void testCanonicalization() {
        for (String[] params : new String[][]{{"f\u00f6\u00f6/", "f\u00f6\u00f6"}, {"/f\u00f6\u00f6", "f\u00f6\u00f6"}, {"/f\u00f6\u00f6/", "f\u00f6\u00f6"}, {"/C:/", "C%3A"}, {"C%3A/", "C%3A"}}) {
            URI uri = URI.create(params[0]);
            URI expected = URI.create(params[1]);
            FsNodeName name = FsNodeName.create((URI)uri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            URI result = name.getUri();
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)expected));
        }
    }

    @Test
    public void testIsRoot() {
        for (Object[] params : new Object[][]{{"", true}, {"?", false}}) {
            Assert.assertThat((Object)FsNodeName.create((URI)URI.create(params[0].toString())).isRoot(), (Matcher)CoreMatchers.is((Object)params[1]));
        }
    }
}

