/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.FsUriModifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsMountPointTest {
    private static final Logger logger = LoggerFactory.getLogger(FsMountPoint.class);

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"zip:zip:file:/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r!/"}, {"zip:file:/f\u00f6\u00f6%20b\u00e4r!/"}, {"file:/f\u00f6\u00f6%20b\u00e4r/"}}) {
            Object clone;
            FsMountPoint original = FsMountPoint.create((URI)URI.create(params[0]));
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(original);
            }
            logger.trace("Number of serialized bytes: {}", (Object)bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                clone = ois.readObject();
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            clone = null;
            try {
                enc.setExceptionListener(listener);
                enc.writeObject(original);
            }
            catch (Throwable x2) {
                clone = x2;
                throw x2;
            }
            finally {
                if (enc != null) {
                    if (clone != null) {
                        try {
                            enc.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)clone).addSuppressed(x2);
                        }
                    } else {
                        enc.close();
                    }
                }
            }
            logger.trace("XML String: {}", (Object)bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            var11_15 = null;
            try (XMLDecoder dec = new XMLDecoder(bis);){
                clone = dec.readObject();
            }
            catch (Throwable throwable) {
                var11_15 = throwable;
                throw throwable;
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() throws URISyntaxException {
        try {
            FsMountPoint.create((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsMountPoint.create((URI)null, (FsUriModifier)FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((URI)null, FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsMountPoint.create((URI)null, (FsUriModifier)FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((URI)null, FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsMountPoint.create((FsScheme)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((FsScheme)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        for (String string : new String[]{"foo:/?queryDefined", "foo:bar:baz:/!/!/", "foo", "foo/bar", "foo/bar/", "/foo", "/foo/bar", "/foo/bar/", "//foo", "/../foo", "foo:/bar#baz", "foo:/bar/#baz", "foo:/bar", "foo:/bar?baz", "foo:/bar//", "foo:/bar/.", "foo:/bar/./", "foo:/bar/..", "foo:/bar/../", "foo:bar!/", "foo:bar:baz!/", "foo:bar:/baz!//", "foo:bar:/baz!/.", "foo:bar:/baz!/./", "foo:bar:/baz!/..", "foo:bar:/baz!/../", "foo:bar:/baz!/bang", "foo:bar:/baz!/#bang", "foo:bar:/baz/!/", "foo:bar:baz:/bang!/!/"}) {
            URI uri = URI.create(string);
            try {
                FsMountPoint.create((URI)uri);
                Assert.fail((String)string);
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                new FsMountPoint(uri);
                Assert.fail((String)string);
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
        for (String string : new String[][]{{"foo", "bar:baz:/bang!/"}, {"foo", "bar:/baz/"}}) {
            FsScheme scheme = FsScheme.create((String)string[0]);
            FsNodePath path = FsNodePath.create((URI)URI.create(string[1]));
            try {
                new FsMountPoint(scheme, path);
                Assert.fail((String)(string[0] + ":" + string[1] + "!/"));
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructorWithValidUri() {
        for (String string : new String[]{"foo:/b\u00e4r/b\u00e4z/", "foo:/b\u00e4r/", "foo:/"}) {
            URI uri = URI.create(string);
            FsMountPoint mountPoint = FsMountPoint.create((URI)uri);
            Assert.assertThat((Object)mountPoint.getUri(), (Matcher)CoreMatchers.sameInstance((Object)uri));
            Assert.assertThat((Object)mountPoint.getPath(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)mountPoint.toString(), (Matcher)CoreMatchers.equalTo((Object)mountPoint.getUri().toString()));
            Assert.assertThat((Object)mountPoint, (Matcher)CoreMatchers.equalTo((Object)FsMountPoint.create((URI)mountPoint.getUri())));
            Assert.assertThat((Object)mountPoint.hashCode(), (Matcher)CoreMatchers.equalTo((Object)FsMountPoint.create((URI)mountPoint.getUri()).hashCode()));
        }
        for (String string : new String[][]{{"bar:baz:/ba%20ng!/", "bar", "baz:/ba%20ng"}, {"foo:bar:baz:/ba%20ng!/bo%20om?plo%20nk!/", "foo", "bar:baz:/ba%20ng!/bo%20om?plo%20nk"}, {"foo:bar:baz:/./b\u00e4ng!/./b\u00f6\u00f6m?pl\u00f6nk!/", "foo", "bar:baz:/b\u00e4ng!/b\u00f6\u00f6m?pl\u00f6nk"}, {"foo:bar:baz:/./bang!/boom?plonk!/", "foo", "bar:baz:/bang!/boom?plonk"}, {"foo:bar:baz:/bang!/./boom?plonk!/", "foo", "bar:baz:/bang!/boom?plonk"}, {"foo:bar:baz:/bang!/boom?plonk!/", "foo", "bar:baz:/bang!/boom?plonk"}, {"foo:bar:baz:/bang!/boom!/", "foo", "bar:baz:/bang!/boom"}, {"foo:bar:/baz?bang!/", "foo", "bar:/baz?bang"}, {"foo:bar:/baz!/", "foo", "bar:/baz"}}) {
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(string[0]), (FsUriModifier)FsUriModifier.CANONICALIZE);
            FsScheme scheme = FsScheme.create((String)string[1]);
            FsNodePath path = FsNodePath.create((URI)URI.create(string[2]));
            Assert.assertThat((Object)mountPoint.getScheme(), (Matcher)CoreMatchers.equalTo((Object)scheme));
            Assert.assertThat((Object)mountPoint.getPath(), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)mountPoint.toString(), (Matcher)CoreMatchers.equalTo((Object)mountPoint.getUri().toString()));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.getUri()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((URI)URI.create(mountPoint.getUri().getScheme() + ":" + mountPoint.getPath() + "!/")), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((FsScheme)mountPoint.getScheme(), (FsNodePath)mountPoint.getPath()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.getUri()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.getUri()).hashCode(), (Matcher)CoreMatchers.equalTo((Object)mountPoint.hashCode()));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.resolve(FsNodeName.ROOT).getUri()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
        }
    }

    @Test
    public void testResolve() {
        for (String[] params : new String[][]{{"foo:bar:/baz?plonk!/", "", "baz", "foo:bar:/baz?plonk!/"}, {"foo:bar:/b\u00e4z?b\u00f6\u00f6m!/", "b\u00e4ng?pl\u00f6nk", "b\u00e4z/b\u00e4ng?pl\u00f6nk", "foo:bar:/b\u00e4z?b\u00f6\u00f6m!/b\u00e4ng?pl\u00f6nk"}, {"foo:bar:/baz!/", "bang?boom", "baz/bang?boom", "foo:bar:/baz!/bang?boom"}, {"foo:bar:/baz!/", "bang", "baz/bang", "foo:bar:/baz!/bang"}, {"foo:bar:/baz!/", "", "baz", "foo:bar:/baz!/"}, {"foo:bar:/baz?plonk!/", "bang?boom", "baz/bang?boom", "foo:bar:/baz?plonk!/bang?boom"}, {"foo:bar:/baz?plonk!/", "bang", "baz/bang", "foo:bar:/baz?plonk!/bang"}, {"foo:/bar/", "baz?bang", null, "foo:/bar/baz?bang"}, {"foo:/bar/", "baz", null, "foo:/bar/baz"}, {"foo:/bar/", "", null, "foo:/bar/"}, {"foo:/bar/", "baz", null, "foo:/bar/baz"}}) {
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            FsNodeName entryName = FsNodeName.create((URI)URI.create(params[1]));
            FsNodeName parentEntryName = null == params[2] ? null : FsNodeName.create((URI)URI.create(params[2]));
            FsNodePath path = FsNodePath.create((URI)URI.create(params[3]));
            if (null != parentEntryName) {
                Assert.assertThat((Object)mountPoint.getPath().resolve(entryName).getNodeName(), (Matcher)CoreMatchers.equalTo((Object)parentEntryName));
            }
            Assert.assertThat((Object)mountPoint.resolve(entryName), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)mountPoint.resolve(entryName).getUri().isAbsolute(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testHierarchicalize() {
        for (String[] params : new String[][]{{"foo:bar:baz:/x/b\u00f6%20m?pl\u00f6%20k!/b\u00e4%20g?z\u00f6%20k!/", "baz:/x/b\u00f6%20m/b\u00e4%20g?z\u00f6%20k"}, {"foo:bar:baz:/x/b\u00f6\u00f6m?pl\u00f6nk!/b\u00e4ng?z\u00f6nk!/", "baz:/x/b\u00f6\u00f6m/b\u00e4ng?z\u00f6nk"}, {"foo:bar:baz:/boom?plonk!/bang?zonk!/", "baz:/boom/bang?zonk"}, {"foo:bar:baz:/boom!/bang!/", "baz:/boom/bang"}, {"foo:bar:/baz?boom!/", "bar:/baz?boom"}, {"foo:bar:/baz!/", "bar:/baz"}, {"foo:/bar/", "foo:/bar/"}}) {
            FsMountPoint mp = FsMountPoint.create((URI)URI.create(params[0]));
            URI hmp = mp.toHierarchicalUri();
            FsNodePath p = FsNodePath.create((URI)URI.create(params[0]));
            URI hp = p.toHierarchicalUri();
            Assert.assertThat((Object)hmp, (Matcher)CoreMatchers.equalTo((Object)URI.create(params[1])));
            Assert.assertThat((Object)hmp, (Matcher)CoreMatchers.equalTo((Object)hp));
        }
    }
}

