/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.net.URI;
import javax.annotation.CheckForNull;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsTestModel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsModelTest {
    protected FsModel newModel(FsMountPoint mountPoint, @CheckForNull FsModel parent) {
        return new FsTestModel(mountPoint, parent);
    }

    private FsModel newModel(FsMountPoint mountPoint) {
        return this.newModel(mountPoint, null == mountPoint.getParent() ? null : this.newModel(mountPoint.getParent()));
    }

    @Test
    public void testConstructorWithNull() {
        try {
            this.newModel(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructorWithMountPoint() {
        for (String[] params : new String[][]{{"foo:/bar/"}}) {
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            FsModel model = this.newModel(mountPoint, null);
            Assert.assertThat((Object)model.getMountPoint(), (Matcher)CoreMatchers.sameInstance((Object)mountPoint));
            Assert.assertThat((Object)model.getMountPoint().getPath(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)model.getParent(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)model.isMounted(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testConstructorWithMountPointAndParent() {
        FsMountPoint parentMountPoint;
        FsMountPoint mountPoint;
        for (String[] params : new String[][]{{"foo:/bar/baz/", "foo:/bar/"}, {"foo:/bar/", "foo:/baz/"}}) {
            mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            parentMountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            FsModel parent = this.newModel(parentMountPoint, null);
            try {
                this.newModel(mountPoint, parent);
                Assert.fail((String)params[0]);
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
        }
        for (String[] params : new String[][]{{"foo:bar:baz:/boom!/bang!/", "bar:baz:/boom!/", "plonk", "bang/plonk", "foo:bar:baz:/boom!/bang!/plonk"}, {"foo:bar:/baz!/", "bar:/", "boom", "baz/boom", "foo:bar:/baz!/boom"}}) {
            mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            parentMountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            FsNodeName entryName = FsNodeName.create((URI)URI.create(params[2]));
            FsNodeName parentEntryName = FsNodeName.create((URI)URI.create(params[3]));
            FsNodePath path = FsNodePath.create((URI)URI.create(params[4]));
            FsModel parent = this.newModel(parentMountPoint);
            FsModel model = this.newModel(mountPoint, parent);
            Assert.assertThat((Object)model.getMountPoint(), (Matcher)CoreMatchers.sameInstance((Object)mountPoint));
            Assert.assertThat((Object)model.getParent(), (Matcher)CoreMatchers.sameInstance((Object)parent));
            Assert.assertThat((Object)model.getMountPoint().getPath().resolve(entryName).getNodeName(), (Matcher)CoreMatchers.equalTo((Object)parentEntryName));
            Assert.assertThat((Object)model.getMountPoint().resolve(entryName), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)model.isMounted(), (Matcher)CoreMatchers.is((Object)false));
        }
    }
}

