/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.services.Container;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsControllerFilter;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsSimpleCompositeDriver;
import net.java.truevfs.kernel.spec.mock.MockDriverMapContainer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FsManagerTestSuite {
    private final FsCompositeDriver driver = new FsSimpleCompositeDriver((Container)new MockDriverMapContainer("file|tar|tar.gz|zip"));
    private FsManager manager;

    @Before
    public void setUp() {
        this.manager = this.newManager();
    }

    protected abstract FsManager newManager();

    @Test
    public void testGetControllerWithNull() {
        try {
            this.newManager().controller(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testForward() throws InterruptedException {
        for (String[] params : new String[][]{{"file:/", "zip:file:/\u00f6uter.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/"}, {"file:/", "zip:file:/f\u00f6o.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/"}}) {
            FsController parent = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.controller(this.driver, mountPoint);
                if (null != parent && null != parent.getParent()) {
                    Assert.assertThat((Object)controller.getParent(), (Matcher)CoreMatchers.sameInstance((Object)parent));
                }
                parent = controller;
            }
            Assert.assertThat((Object)this.count((Filter<? super FsController>)Filter.ACCEPT_ANY), (Matcher)CoreMatchers.is((Object)params.length));
            Assert.assertThat((Object)this.count((Filter<? super FsController>)Filter.ACCEPT_NONE), (Matcher)CoreMatchers.is((Object)0));
            parent = null;
            this.waitForAllManagersToGetGarbageCollected();
        }
    }

    @Test
    public void testBackward() throws InterruptedException {
        for (String[] params : new String[][]{{"zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:file:/\u00f6uter.zip!/", "file:/"}, {"zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:file:/f\u00f6o.zip!/", "file:/"}}) {
            FsController top = null;
            FsController member = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.controller(this.driver, mountPoint);
                if (null != member && null != controller.getParent()) {
                    Assert.assertThat((Object)controller, (Matcher)CoreMatchers.sameInstance((Object)member.getParent()));
                }
                member = controller;
                if (null != top) continue;
                top = controller;
            }
            final Iterator<String> it = Arrays.asList(params).iterator();
            class ControllerVisitor
            extends VisitCounter {
                ControllerVisitor() {
                }

                @Override
                public void visit(FsController controller) {
                    FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create((String)it.next()));
                    Assert.assertThat((Object)controller.getModel().getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
                    super.visit(controller);
                }
            }
            Assert.assertThat((Object)this.count((Filter<? super FsController>)Filter.ACCEPT_ANY, new ControllerVisitor()), (Matcher)CoreMatchers.is((Object)params.length));
            Assert.assertThat((Object)it.hasNext(), (Matcher)CoreMatchers.is((Object)false));
            member = null;
            top = null;
            this.waitForAllManagersToGetGarbageCollected();
        }
    }

    private void waitForAllManagersToGetGarbageCollected() {
        do {
            System.gc();
        } while (0 < this.count((Filter<? super FsController>)Filter.ACCEPT_ANY));
    }

    @Test
    public void testFiltering() {
        for (String[][] params : new String[][][]{{{"tar:file:/bar.tar!/"}, {"file:/", "tar:file:/bar.tar!/", "tar.gz:file:/bar.tar.gz!/"}, {"tar:file:/bar.tar!/"}}, {{"tar:zip:file:/foo.zip!/bar.tar!/"}, {"file:/", "zip:file:/foo.zip!/", "tar:file:/bar.tar!/"}, new String[0]}, {{"file:/foo.zip/bar.tar/"}, {"file:/", "zip:file:/foo.zip!/", "tar:file:/bar.tar!/"}, new String[0]}, {{"tar:file:/foo!/"}, {"file:/", "zip:file:/foo!/", "tar:file:/bar!/"}, {"zip:file:/foo!/"}}, {{"zip:file:/foo.zip!/"}, {"file:/", "zip:file:/foo.zip!/", "tar:file:/bar.tar!/"}, {"zip:file:/foo.zip!/"}}, {{"file:/foo.zip/"}, {"file:/", "zip:file:/foo.zip!/", "tar:file:/bar.tar!/"}, new String[0]}, {{"file:/"}, {"file:/", "zip:file:/foo.zip!/", "tar:file:/bar.tar!/"}, {"file:/", "zip:file:/foo.zip!/", "tar:file:/bar.tar!/"}}}) {
            assert (params[0].length == 1);
            this.manager = this.newManager();
            final HashSet<FsController> input = new HashSet<FsController>();
            for (String param : params[1]) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                input.add(this.manager.controller(this.driver, mountPoint));
            }
            class InputVisitor
            extends VisitCounter {
                InputVisitor() {
                }

                @Override
                public void visit(FsController controller) {
                    Assert.assertTrue((boolean)input.contains(controller));
                    super.visit(controller);
                }
            }
            Assert.assertThat((Object)this.count((Filter<? super FsController>)Filter.ACCEPT_ANY, new InputVisitor()), (Matcher)CoreMatchers.is((Object)params[1].length));
            final HashSet<FsMountPoint> output = new HashSet<FsMountPoint>();
            for (String param : params[2]) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                output.add(mountPoint);
            }
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[0][0]));
            class FilterVisitor
            extends VisitCounter {
                FilterVisitor() {
                }

                @Override
                public void visit(FsController controller) {
                    Assert.assertTrue((boolean)output.remove(controller.getModel().getMountPoint()));
                    super.visit(controller);
                }
            }
            Assert.assertThat((Object)this.count((Filter<? super FsController>)new FsControllerFilter(mountPoint), new FilterVisitor()), (Matcher)CoreMatchers.is((Object)params[2].length));
            Assert.assertTrue((boolean)output.isEmpty());
        }
    }

    private int count(Filter<? super FsController> filter) {
        return this.count(filter, new VisitCounter());
    }

    private int count(Filter<? super FsController> filter, VisitCounter counter) {
        try {
            this.manager.accept(filter, (Visitor)counter);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return counter.get();
    }

    @ThreadSafe
    private static class VisitCounter
    extends AtomicInteger
    implements Visitor<FsController, IOException> {
        private VisitCounter() {
        }

        public void visit(FsController controller) {
            Assert.assertThat((Object)controller, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)null)));
            this.incrementAndGet();
        }
    }
}

