/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import net.java.truecommons.cio.Container;
import net.java.truecommons.cio.DecoratingInputSocket;
import net.java.truecommons.cio.DecoratingOutputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.DecoratingInputStream;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.DecoratingSeekableChannel;
import net.java.truecommons.io.PowerBuffer;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Throwables;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsArchiveDriverTestBase;
import net.java.truevfs.kernel.spec.FsArchiveEntry;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsTestConfig;
import net.java.truevfs.kernel.spec.FsTestModel;
import net.java.truevfs.kernel.spec.FsThrowManager;
import net.java.truevfs.kernel.spec.mock.MockController;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FsArchiveDriverTestSuite<E extends FsArchiveEntry, D extends FsArchiveDriver<E>>
extends FsArchiveDriverTestBase<D> {
    private static final Logger logger = LoggerFactory.getLogger(FsArchiveDriverTestSuite.class);
    private static final FsNodeName name = FsNodeName.create((URI)URI.create("archive"));
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String US_ASCII_CHARACTERS;
    private FsModel model;
    private FsController parent;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        FsTestConfig config = FsTestConfig.get();
        config.setDataSize(this.getMaxArchiveLength());
        config.setPool(null);
        this.model = this.newArchiveModel();
        this.parent = this.newParentController(this.model.getParent());
        assert (!UTF8.equals(this.getArchiveDriver().getCharset()) || null == this.getUnencodableName()) : "Bad test setup!";
    }

    @CheckForNull
    protected abstract String getUnencodableName();

    @Test
    public void testCharsetMustNotBeNull() {
        assert (null != this.getArchiveDriver().getCharset());
    }

    @Test
    public void testUnencodableCharacters() {
        String name = this.getUnencodableName();
        if (null != name) {
            Assert.assertFalse((boolean)this.getArchiveDriver().getCharset().newEncoder().canEncode(name));
        }
    }

    @Test
    public void testAllUsAsciiCharactersMustBeEncodable() throws CharConversionException {
        this.getArchiveDriver().getCharset().newEncoder().canEncode(US_ASCII_CHARACTERS);
    }

    @Test
    public void testArchiveDriverProperty() {
        Assert.assertTrue((boolean)this.getArchiveDriver().isArchiveDriver());
    }

    @Test
    public void testIoPoolMustNotBeNull() {
        Assert.assertNotNull((Object)this.getArchiveDriver().getPool());
    }

    @Test
    public void testIoPoolShouldBeConstant() {
        IoBufferPool p2;
        IoBufferPool p1 = this.getArchiveDriver().getPool();
        if (p1 != (p2 = this.getArchiveDriver().getPool())) {
            logger.warn("{} returns different I/O buffer pools upon multiple invocations of getPool()!", this.getArchiveDriver().getClass());
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNewInputMustNotTolerateNullModel() throws IOException {
        this.getArchiveDriver().newInput(null, FsAccessOptions.NONE, this.parent, name);
    }

    @Test(expected=NullPointerException.class)
    public void testNewInputMustNotTolerateNullParentController() throws IOException {
        this.getArchiveDriver().newInput(this.model, FsAccessOptions.NONE, null, name);
    }

    @Test(expected=NullPointerException.class)
    public void testNewInputMustNotTolerateNullEntryName() throws IOException {
        this.getArchiveDriver().newInput(this.model, FsAccessOptions.NONE, this.parent, null);
    }

    @Test(expected=NullPointerException.class)
    public void testNewInputMustNotTolerateNullOptions() throws IOException {
        this.getArchiveDriver().newInput(this.model, null, this.parent, name);
    }

    @Test(expected=NullPointerException.class)
    public void testNewOutputMustNotTolerateNullModel() throws IOException {
        this.getArchiveDriver().newOutput(null, FsAccessOptions.NONE, this.parent, name, null);
    }

    @Test(expected=NullPointerException.class)
    public void testNewOutputMustNotTolerateNullParentController() throws IOException {
        this.getArchiveDriver().newOutput(this.model, FsAccessOptions.NONE, null, name, null);
    }

    @Test(expected=NullPointerException.class)
    public void testNewOutputMustNotTolerateNullEntryName() throws IOException {
        this.getArchiveDriver().newOutput(this.model, FsAccessOptions.NONE, this.parent, null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testNewOutputMustNotTolerateNullOptions() throws IOException {
        this.getArchiveDriver().newOutput(this.model, null, this.parent, name, null);
    }

    @Test
    public void testEmptyRoundTripPersistence() throws IOException {
        this.roundTripPersistence(0);
    }

    @Test
    public void testStandardRoundTripPersistence() throws IOException {
        this.roundTripPersistence(this.getNumEntries());
    }

    private void roundTripPersistence(int numEntries) throws IOException {
        this.output(numEntries);
        this.input(numEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(int numEntries) throws IOException {
        OutputService service = this.getArchiveDriver().newOutput(this.model, FsAccessOptions.NONE, this.parent, name, null);
        try {
            Closeable[] streams = new Closeable[numEntries];
            try {
                for (int i = 0; i < streams.length; ++i) {
                    streams[i] = this.output(service, i);
                }
            }
            finally {
                FsArchiveDriverTestSuite.close(streams);
            }
            this.check((Container<E>)service, numEntries);
        }
        finally {
            IOException expected = new IOException();
            this.trigger(TestCloseable.class, expected);
            try {
                service.close();
            }
            catch (IOException got) {
                if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                    throw got;
                }
            }
            finally {
                this.clear(TestCloseable.class);
            }
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CreatesObligation
    private OutputStream output(OutputService<E> service, int i) throws IOException {
        String name = FsArchiveDriverTestSuite.name(i);
        E entry = this.newEntry(name);
        OutputSocket output = service.output(entry);
        Assert.assertSame(entry, (Object)output.target());
        Assert.assertNull((Object)service.entry(name));
        Assert.assertEquals((long)i, (long)service.size());
        boolean failure = true;
        OutputStream out = output.stream(null);
        try {
            Assert.assertSame(entry, (Object)service.entry(name));
            Assert.assertEquals((long)(i + 1), (long)service.size());
            out.write(this.getData());
            failure = false;
        }
        finally {
            if (failure) {
                out.close();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void input(int numEntries) throws IOException {
        InputService service = this.getArchiveDriver().newInput(this.model, FsAccessOptions.NONE, this.parent, name);
        try {
            this.check((Container<E>)service, numEntries);
            Closeable[] streams = new Closeable[numEntries];
            try {
                for (int i = 0; i < streams.length; ++i) {
                    this.input(service, i).close();
                    streams[i] = this.input(service, i);
                }
            }
            finally {
                FsArchiveDriverTestSuite.close(streams);
            }
        }
        finally {
            IOException expected = new IOException();
            this.trigger(TestCloseable.class, expected);
            try {
                service.close();
            }
            catch (IOException got) {
                if (!Throwables.contains((Throwable)got, (Throwable)expected)) {
                    throw got;
                }
            }
            finally {
                this.clear(TestCloseable.class);
            }
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream input(InputService<E> service, int i) throws IOException {
        SeekableByteChannel channel;
        InputSocket input = service.input(FsArchiveDriverTestSuite.name(i));
        Object buf = PowerBuffer.allocate((int)this.getDataLength());
        try {
            channel = input.channel(null);
        }
        catch (UnsupportedOperationException ex) {
            channel = null;
            logger.trace(input.getClass().getName(), (Throwable)ex);
        }
        if (null != channel) {
            try {
                buf.load((ReadableByteChannel)channel);
                Assert.assertEquals((long)channel.position(), (long)channel.size());
            }
            finally {
                channel.close();
            }
            channel.close();
            Assert.assertTrue((boolean)Arrays.equals(this.getData(), buf.array()));
        }
        buf = new byte[this.getDataLength()];
        boolean failure = true;
        DataInputStream in = new DataInputStream(input.stream(null));
        try {
            in.readFully((byte[])buf);
            Assert.assertTrue((boolean)Arrays.equals(this.getData(), (byte[])buf));
            Assert.assertEquals((long)-1L, (long)in.read());
            failure = false;
        }
        finally {
            if (failure) {
                in.close();
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable[] resources) throws IOException {
        IOException ex = null;
        for (Closeable resource : resources) {
            if (null == resource) continue;
            try {
                try {
                    resource.close();
                }
                finally {
                    resource.close();
                }
            }
            catch (IOException ex2) {
                if (null != ex) {
                    ex.addSuppressed(ex2);
                    continue;
                }
                ex = ex2;
            }
        }
        if (null != ex) {
            throw ex;
        }
    }

    private <E extends FsArchiveEntry> void check(Container<E> container, int numEntries) {
        Assert.assertEquals((long)numEntries, (long)container.size());
        Iterator it = container.iterator();
        for (int i = 0; i < numEntries; ++i) {
            FsArchiveEntry e = (FsArchiveEntry)it.next();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((Object)FsArchiveDriverTestSuite.name(i), (Object)e.getName());
            Assert.assertSame((Object)Entry.Type.FILE, (Object)e.getType());
            Assert.assertEquals((long)this.getDataLength(), (long)e.getSize(Entry.Size.DATA));
            long storage = e.getSize(Entry.Size.STORAGE);
            Assert.assertTrue((-1L == storage || (long)this.getDataLength() <= storage ? 1 : 0) != 0);
            Assert.assertTrue((-1L != e.getTime(Entry.Access.WRITE) ? 1 : 0) != 0);
            try {
                it.remove();
                Assert.fail();
            }
            catch (UnsupportedOperationException expected) {
                // empty catch block
            }
            Assert.assertSame((Object)e, (Object)container.entry(e.getName()));
        }
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            it.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)numEntries, (long)container.size());
    }

    private E newEntry(String name) throws CharConversionException {
        FsArchiveEntry e = this.getArchiveDriver().newEntry(name, Entry.Type.FILE, null);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)name, (Object)e.getName());
        Assert.assertSame((Object)Entry.Type.FILE, (Object)e.getType());
        Assert.assertTrue((-1L == e.getSize(Entry.Size.DATA) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getSize(Entry.Size.STORAGE) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getTime(Entry.Access.WRITE) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getTime(Entry.Access.READ) ? 1 : 0) != 0);
        Assert.assertTrue((-1L == e.getTime(Entry.Access.CREATE) ? 1 : 0) != 0);
        return (E)e;
    }

    private static String name(int i) {
        return Integer.toString(i);
    }

    private MockController newParentController(FsModel model) {
        FsModel pm = model.getParent();
        MockController pc = null == pm ? null : this.newParentController(pm);
        return new ParentController(model, (FsController)pc);
    }

    private FsModel newArchiveModel() {
        FsModel parent = this.newNonArchiveModel();
        return this.newModel(FsMountPoint.create((URI)URI.create("scheme:" + parent.getMountPoint() + name + "!/")), parent);
    }

    private FsModel newNonArchiveModel() {
        return this.newModel(FsMountPoint.create((URI)URI.create("file:/")), null);
    }

    protected FsModel newModel(FsMountPoint mountPoint, @CheckForNull FsModel parent) {
        return new FsTestModel(mountPoint, parent);
    }

    private int getMaxArchiveLength() {
        return this.getNumEntries() * this.getDataLength() * 4 / 3;
    }

    private Throwable trigger(Class<?> from, Throwable toThrow) {
        return this.getThrowControl().trigger(from, toThrow);
    }

    private Throwable clear(Class<?> from) {
        return this.getThrowControl().clear(from);
    }

    private void checkAllExceptions(Object thiz) throws IOException {
        FsThrowManager ctl = this.getThrowControl();
        ctl.check(thiz, IOException.class);
        ctl.check(thiz, RuntimeException.class);
        ctl.check(thiz, Error.class);
    }

    private FsThrowManager getThrowControl() {
        return FsTestConfig.get().getThrowControl();
    }

    private int getNumEntries() {
        return FsTestConfig.get().getNumEntries();
    }

    static {
        StringBuilder builder = new StringBuilder(128);
        for (char c = '\u0000'; c <= '\u007f'; c = (char)(c + '\u0001')) {
            builder.append(c);
        }
        US_ASCII_CHARACTERS = builder.toString();
    }

    private final class TestSeekableChannel
    extends DecoratingSeekableChannel
    implements TestCloseable {
        TestSeekableChannel(SeekableByteChannel channel) {
            super(channel);
        }

        @Override
        public void close() throws IOException {
            FsArchiveDriverTestSuite.this.checkAllExceptions(this);
            this.channel.close();
        }
    }

    private final class TestOutputStream
    extends DecoratingOutputStream
    implements TestCloseable {
        TestOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            FsArchiveDriverTestSuite.this.checkAllExceptions(this);
            this.out.close();
        }
    }

    private final class TestInputStream
    extends DecoratingInputStream
    implements TestCloseable {
        TestInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            FsArchiveDriverTestSuite.this.checkAllExceptions(this);
            this.in.close();
        }
    }

    private static interface TestCloseable
    extends Closeable {
    }

    private final class ParentController
    extends MockController {
        ParentController(@CheckForNull FsModel model, FsController parent) {
            super(model, parent, FsTestConfig.get());
        }

        @Override
        public InputSocket<?> input(final BitField<FsAccessOption> options, final FsNodeName name) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(options);
            final class Input
            extends DecoratingInputSocket<Entry> {
                Input() {
                    super(ParentController.access$001(ParentController.this, bitField, fsNodeName));
                }

                public InputStream stream(OutputSocket<? extends Entry> peer) throws IOException {
                    return new TestInputStream(this.socket().stream(peer));
                }

                public SeekableByteChannel channel(OutputSocket<? extends Entry> peer) throws IOException {
                    return new TestSeekableChannel(this.socket().channel(peer));
                }
            }
            return new Input();
        }

        @Override
        public OutputSocket<?> output(final BitField<FsAccessOption> options, final FsNodeName name, final @CheckForNull Entry template) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(options);
            final class Output
            extends DecoratingOutputSocket<Entry> {
                Output() {
                    super(ParentController.access$101(ParentController.this, bitField, fsNodeName, entry));
                }

                public SeekableByteChannel channel(InputSocket<? extends Entry> peer) throws IOException {
                    return new TestSeekableChannel(this.socket().channel(peer));
                }

                public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                    return new TestOutputStream(this.socket().stream(peer));
                }
            }
            return new Output();
        }

        static /* synthetic */ InputSocket access$001(ParentController x0, BitField x1, FsNodeName x2) {
            return super.input((BitField<FsAccessOption>)x1, x2);
        }

        static /* synthetic */ OutputSocket access$101(ParentController x0, BitField x1, FsNodeName x2, Entry x3) {
            return super.output((BitField<FsAccessOption>)x1, x2, x3);
        }
    }
}

