/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.ext.pacemaker;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truecommons.shed.Filter;
import net.java.truevfs.comp.jmx.JmxManager;
import net.java.truevfs.comp.jmx.JmxMediator;
import net.java.truevfs.ext.pacemaker.LruCache;
import net.java.truevfs.ext.pacemaker.PaceManager$;
import net.java.truevfs.ext.pacemaker.PaceManagerView;
import net.java.truevfs.ext.pacemaker.PaceMediator;
import net.java.truevfs.kernel.spec.FsControllerFilter;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsOpenResourceException;
import net.java.truevfs.kernel.spec.FsPrefixMountPointFilter;
import net.java.truevfs.kernel.spec.FsSync;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncExceptionBuilder;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0005\u001b\tY\u0001+Y2f\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0005qC\u000e,W.Y6fe*\u0011QAB\u0001\u0004Kb$(BA\u0004\t\u0003\u001d!(/^3wMNT!!\u0003\u0006\u0002\t)\fg/\u0019\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001M\u0011\u0001A\u0004\t\u0004\u001fQ1R\"\u0001\t\u000b\u0005E\u0011\u0012a\u00016nq*\u00111CB\u0001\u0005G>l\u0007/\u0003\u0002\u0016!\tQ!*\u001c=NC:\fw-\u001a:\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!\u0001\u0004)bG\u0016lU\rZ5bi>\u0014\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u00115,G-[1u_JD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\b[\u0006t\u0017mZ3s!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003ta\u0016\u001c'BA\u0012\u0007\u0003\u0019YWM\u001d8fY&\u0011Q\u0005\t\u0002\n\rNl\u0015M\\1hKJDQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDcA\u0015+WA\u0011q\u0003\u0001\u0005\u00067\u0019\u0002\rA\u0006\u0005\u0006;\u0019\u0002\rA\b\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0003E\u0019\u0017m\u00195fI6{WO\u001c;Q_&tGo]\u000b\u0002_A\u0019q\u0003\r\u001a\n\u0005E\u0012!\u0001\u0003'sk\u000e\u000b7\r[3\u0011\u0005}\u0019\u0014B\u0001\u001b!\u0005115/T8v]R\u0004v.\u001b8u\u0011\u00191\u0004\u0001)A\u0005_\u0005\u00112-Y2iK\u0012lu.\u001e8u!>Lg\u000e^:!\u0011\u001dA\u0004A1A\u0005\ne\n!#\u001a<jGR,G-T8v]R\u0004v.\u001b8ugV\t!\bE\u0002<\u007fIj\u0011\u0001\u0010\u0006\u0003{y\nA!\u001e;jY*\t\u0011\"\u0003\u0002Ay\t\u00191+\u001a;\t\r\t\u0003\u0001\u0015!\u0003;\u0003M)g/[2uK\u0012lu.\u001e8u!>Lg\u000e^:!\u0011\u0015!\u0005\u0001\"\u0001F\u0003-i\u0017\r_5nk6\u001c\u0016N_3\u0016\u0003\u0019\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u00131!\u00138u\u0011\u0015i\u0005\u0001\"\u0001O\u0003=i\u0017\r_5nk6\u001c\u0016N_3`I\u0015\fHCA(S!\t9\u0005+\u0003\u0002R\u0011\n!QK\\5u\u0011\u0015!E\n1\u0001G\u0011\u0015!\u0006\u0001\"\u0011V\u0003\u001dqWm\u001e,jK^$\u0012A\u0016\t\u0003/]K!\u0001\u0017\u0002\u0003\u001fA\u000b7-Z'b]\u0006<WM\u001d,jK^DQA\u0017\u0001\u0005\u0002m\u000bAB]3d_J$\u0017iY2fgN$\"a\u0014/\t\u000buK\u0006\u0019\u0001\u001a\u0002\u00155|WO\u001c;Q_&tG\u000fC\u0003`\u0001\u0011%\u0001-\u0001\u0011v]6|WO\u001c;Fm&\u001cG/\u001a3Be\u000eD\u0017N^3GS2,7+_:uK6\u001cH#A(\b\u000b\t\u0014\u0001\u0012B2\u0002\u0017A\u000b7-Z'b]\u0006<WM\u001d\t\u0003/\u00114Q!\u0001\u0002\t\n\u0015\u001c\"\u0001\u001a4\u0011\u0005\u001d;\u0017B\u00015I\u0005\u0019\te.\u001f*fM\")q\u0005\u001aC\u0001UR\t1\rC\u0004mI\n\u0007I\u0011A7\u0002\r1|wmZ3s+\u0005q\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\u001dawnZ4j]\u001eT!a\u001d\u0005\u0002\u0017Q\u0014X/Z2p[6|gn]\u0005\u0003kB\u0014q\u0002T8dC2L'0\u001a3M_\u001e<WM\u001d\u0005\u0007o\u0012\u0004\u000b\u0011\u00028\u0002\u000f1|wmZ3sA\u0001")
public class PaceManager
extends JmxManager<PaceMediator> {
    private final PaceMediator mediator;
    private final FsManager manager;
    private final LruCache<FsMountPoint> cachedMountPoints;
    private final Set<FsMountPoint> evictedMountPoints;

    public static LocalizedLogger logger() {
        return PaceManager$.MODULE$.logger();
    }

    private LruCache<FsMountPoint> cachedMountPoints() {
        return this.cachedMountPoints;
    }

    private Set<FsMountPoint> evictedMountPoints() {
        return this.evictedMountPoints;
    }

    public int maximumSize() {
        return this.mediator.maximumSize();
    }

    public void maximumSize_$eq(int maximumSize) {
        this.mediator.maximumSize_$eq(maximumSize);
    }

    public PaceManagerView newView() {
        return new PaceManagerView(this);
    }

    public void recordAccess(FsMountPoint mountPoint) {
        this.cachedMountPoints().recordAccess(mountPoint);
        this.unmountEvictedArchiveFileSystems();
    }

    private void unmountEvictedArchiveFileSystems() {
        block4: {
            Iterator<FsMountPoint> iterator = this.evictedMountPoints().iterator();
            if (!iterator.hasNext()) break block4;
            FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
            do {
                FsMountPoint evictedMountPoint = iterator.next();
                FsPrefixMountPointFilter evictedMountPointFilter = FsPrefixMountPointFilter.forPrefix((FsMountPoint)evictedMountPoint);
                if (this.cachedMountPoints().exists((Function1<FsMountPoint, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)evictedMountPointFilter.accept(x$1)))) continue;
                try {
                    new FsSync().manager(this.manager).filter((Filter)FsControllerFilter.forPrefix((FsMountPoint)evictedMountPoint)).run();
                    iterator.remove();
                }
                catch (FsSyncException e) {
                    BoxedUnit boxedUnit;
                    Throwable throwable = e.getCause();
                    if (throwable instanceof FsOpenResourceException) {
                        PaceManager$.MODULE$.logger().trace("ignoring", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    iterator.remove();
                    builder.warn((Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            } while (iterator.hasNext());
            builder.check();
        }
    }

    public PaceManager(PaceMediator mediator, FsManager manager) {
        this.mediator = mediator;
        this.manager = manager;
        super((JmxMediator)mediator, manager);
        this.cachedMountPoints = mediator.cachedMountPoints();
        this.evictedMountPoints = mediator.evictedMountPoints();
    }
}

