/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip.it;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.Callable;
import net.java.truecommons.shed.ConcurrencyUtils;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.comp.zip.Crc32Exception;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipEntryFactory;
import net.java.truevfs.comp.zip.ZipFile;
import net.java.truevfs.comp.zip.ZipOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZipITSuite
implements ZipEntryFactory<ZipEntry> {
    private static final Logger logger = LoggerFactory.getLogger(ZipITSuite.class);
    private static final boolean FORCE_ZIP64_EXT = Boolean.getBoolean(ZipEntry.class.getPackage().getName() + ".forceZip64Ext");
    protected static final String TEMP_FILE_PREFIX = "tzp";
    private static final Random rnd = new Random();
    private static final byte[] DATA;
    private Path file;
    private byte[] data;

    @Before
    public void setUp() throws IOException {
        this.file = Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]);
        Files.delete(this.file);
        this.data = (byte[])DATA.clone();
    }

    protected final Path getFile() {
        return this.file;
    }

    protected final byte[] getData() {
        return (byte[])this.data.clone();
    }

    @After
    public void tearDown() {
        try {
            Files.deleteIfExists(this.file);
        }
        catch (IOException ex) {
            logger.trace("Failed to clean up test file (this may be just an aftermath):", (Throwable)ex);
        }
    }

    public ZipEntry newEntry(String name) {
        return new ZipEntry(name);
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out) throws IOException {
        return new ZipOutputStream(out);
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out, Charset charset) throws IOException {
        return new ZipOutputStream(out, charset);
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out, ZipFile appendee) throws IOException {
        return new ZipOutputStream(out, appendee);
    }

    protected ZipFile newZipFile(Path file) throws IOException {
        return new ZipFile(file).recoverLostEntries();
    }

    protected ZipFile newZipFile(Path file, Charset charset) throws IOException {
        return new ZipFile(file, charset).recoverLostEntries();
    }

    protected ZipFile newZipFile(SeekableByteChannel channel) throws IOException {
        return new ZipFile(channel).recoverLostEntries();
    }

    protected ZipFile newZipFile(SeekableByteChannel channel, Charset charset) throws IOException {
        return new ZipFile(channel, charset).recoverLostEntries();
    }

    @Test
    public final void testConstructors() throws Exception {
        Files.write(this.file, this.data, new OpenOption[0]);
        try (SeekableByteChannel channel = Files.newByteChannel(this.file, new OpenOption[0]);){
            try {
                this.newZipOutputStream(null, (Charset)null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipOutputStream(null, (ZipFile)null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipOutputStream((OutputStream)new ByteArrayOutputStream(), (Charset)null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipOutputStream((OutputStream)new ByteArrayOutputStream(), (ZipFile)null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipOutputStream(null, Charset.forName("UTF-8"));
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(this.file, null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile((Path)null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile((Path)null, null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile((Path)null, Charset.forName("UTF-8"));
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(this.file, null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile((SeekableByteChannel)null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile((SeekableByteChannel)null, null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile((SeekableByteChannel)null, Charset.forName("UTF-8"));
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(channel, null);
                Assert.fail();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(this.file);
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(this.file);
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(channel);
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(this.file, Charset.forName("UTF-8"));
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.newZipFile(channel, Charset.forName("UTF-8"));
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        Files.delete(this.file);
    }

    @Test
    public final void testPreambleOfEmptyZipFile() throws IOException {
        this.newZipOutputStream(Files.newOutputStream(this.file, new OpenOption[0])).close();
        try (ZipFile zf = this.newZipFile(this.file);){
            Assert.assertEquals((long)0L, (long)zf.getPreambleLength());
            try (InputStream in = zf.getPreambleInputStream();){
                Assert.assertEquals((long)-1L, (long)in.read());
            }
        }
    }

    @Test
    public final void testGetInputStream() throws IOException {
        try (ZipOutputStream zos = this.newZipOutputStream(Files.newOutputStream(this.file, new OpenOption[0]));){
            zos.putNextEntry(this.newEntry("foo"));
        }
        var2_2 = null;
        try (ZipFile zf = this.newZipFile(this.file);){
            zf.getInputStream("foo").close();
            Assert.assertNull((Object)zf.getInputStream("bar"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public final void testWriteAndReadSingleBytes() throws IOException {
        try (ZipOutputStream zos = this.newZipOutputStream(Files.newOutputStream(this.file, new OpenOption[0]));){
            zos.putNextEntry(this.newEntry("file"));
            for (int i = 0; i < this.data.length; ++i) {
                zos.write((int)this.data[i]);
            }
        }
        var2_2 = null;
        try (ZipFile zf = this.newZipFile(this.file);
             InputStream in = zf.getInputStream("file");){
            int c;
            int i = 0;
            while (0 <= (c = in.read())) {
                Assert.assertEquals((long)(this.data[i] & 0xFF), (long)c);
                ++i;
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public final void testMultithreading() throws Exception {
        this.multithreading(ConcurrencyUtils.NUM_IO_THREADS, ConcurrencyUtils.NUM_IO_THREADS);
    }

    private void multithreading(final int nEntries, int nThreads) throws Exception {
        this.createTestZipFile(nEntries);
        try (final ZipFile zf = this.newZipFile(this.file);){
            final class CheckAllEntriesFactory
            implements ConcurrencyUtils.TaskFactory {
                CheckAllEntriesFactory() {
                }

                public Callable<?> newTask(int threadNum) {
                    return new 1CheckAllEntriesFactory.CheckAllEntries();
                }

                final class 1CheckAllEntriesFactory.CheckAllEntries
                implements Callable<Void> {
                    1CheckAllEntriesFactory.CheckAllEntries() {
                    }

                    @Override
                    public Void call() throws IOException {
                        ArrayList<ZipEntry> entries = Collections.list(zf.entries());
                        assert (entries.size() == nEntries);
                        Collections.shuffle(entries, rnd);
                        byte[] buf = new byte[ZipITSuite.this.data.length];
                        for (ZipEntry entry : entries) {
                            InputStream in = zf.getInputStream(entry.getName());
                            Throwable throwable = null;
                            try {
                                int read;
                                int off = 0;
                                while ((read = in.read(buf)) >= 0) {
                                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                                    Assert.assertEquals((Object)ByteBuffer.wrap(ZipITSuite.this.data, off, read), (Object)ByteBuffer.wrap(buf, 0, read));
                                    off += read;
                                }
                                Assert.assertEquals((long)-1L, (long)read);
                                Assert.assertEquals((long)off, (long)ZipITSuite.this.data.length);
                                Assert.assertTrue((0 >= in.read(new byte[0]) ? 1 : 0) != 0);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (in == null) continue;
                                if (throwable != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                in.close();
                            }
                        }
                        return null;
                    }
                }
            }
            ConcurrencyUtils.start((int)nThreads, (ConcurrencyUtils.TaskFactory)new CheckAllEntriesFactory()).join();
        }
    }

    private void createTestZipFile(int nEntries) throws IOException {
        HashSet<String> set = new HashSet<String>(HashMaps.initialCapacity((int)nEntries));
        try (ZipOutputStream zos = this.newZipOutputStream(Files.newOutputStream(this.file, new OpenOption[0]));){
            for (int i = 0; i < nEntries; ++i) {
                String name = i + ".txt";
                zos.putNextEntry(this.newEntry(name));
                zos.write(this.data);
                Assert.assertTrue((boolean)set.add(name));
            }
        }
        var4_4 = null;
        try (ZipFile zf = this.newZipFile(this.file);){
            for (ZipEntry entry : zf) {
                Assert.assertEquals((long)this.data.length, (long)entry.getSize());
                Assert.assertTrue((boolean)set.remove(entry.getName()));
            }
            Assert.assertTrue((boolean)set.isEmpty());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public final void testGoodGetCheckedInputStream() throws IOException {
        String name = "entry";
        try (ZipOutputStream zos = this.newZipOutputStream(Files.newOutputStream(this.file, new OpenOption[0]));){
            zos.putNextEntry(this.newEntry("entry"));
            zos.write(this.data);
        }
        var3_3 = null;
        try (ZipFile zf = this.newZipFile(this.file);){
            InputStream in = zf.getCheckedInputStream("entry");
            in.close();
            in = zf.getCheckedInputStream("entry");
            int n = this.data.length / 4;
            in.skip(n);
            in.read(new byte[n]);
            in.read(new byte[n], 0, n);
            while (in.read() != -1) {
            }
            in.close();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testBadGetCheckedInputStream() throws IOException {
        if (FORCE_ZIP64_EXT) {
            Assert.fail((String)"TODO: Adapt this test so that it works when ZIP64 extensions have been forced to use!");
        }
        for (int i = 0; i < 4; ++i) {
            String name = "entry";
            try (ZipOutputStream zos = this.newZipOutputStream(Files.newOutputStream(this.file, new OpenOption[0]));){
                zos.putNextEntry(this.newEntry("entry"));
                zos.write(this.data);
            }
            boolean tweakDD = (i & 1) != 0;
            boolean tweakCFH = (i & 2) != 0;
            ByteBuffer crc = ByteBuffer.wrap(new byte[]{-1, -1, -1, -1});
            try (SeekableByteChannel channel = Files.newByteChannel(this.file, StandardOpenOption.WRITE);){
                if (tweakDD) {
                    channel.position(channel.size() - 57L - 28L);
                    channel.write(crc);
                }
                if (tweakCFH) {
                    channel.position(channel.size() - 57L);
                    channel.write(crc);
                }
            }
            var7_12 = null;
            try (ZipFile zf = new ZipFile(this.file);){
                Throwable throwable;
                InputStream in;
                try {
                    in = zf.getCheckedInputStream("entry");
                    throwable = null;
                    try {
                        if (tweakDD ^ tweakCFH) {
                            Assert.fail((String)"Expected CRC32Exception!");
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                    if (tweakDD & tweakCFH) {
                        Assert.fail((String)"Expected CRC32Exception!");
                    }
                }
                catch (Crc32Exception ex) {
                    Assert.assertTrue((boolean)(tweakDD | tweakCFH));
                }
                try {
                    in = zf.getCheckedInputStream("entry");
                    throwable = null;
                    try {
                        if (tweakDD ^ tweakCFH) {
                            Assert.fail((String)"Expected CRC32Exception!");
                        }
                        int n = this.data.length / 4;
                        in.skip(n);
                        in.read(new byte[n]);
                        in.read(new byte[n], 0, n);
                        while (in.read() != -1) {
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                    if (!(tweakDD & tweakCFH)) continue;
                    Assert.fail((String)"Expected CRC32Exception!");
                }
                catch (Crc32Exception ex) {
                    Assert.assertTrue((boolean)(tweakDD | tweakCFH));
                }
                continue;
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testAppending() throws IOException {
        byte[] data1 = this.getData();
        byte[] data2 = new byte[data1.length];
        rnd.nextBytes(data2);
        this.append(0, 20, data1);
        this.append(10, 20, data2);
        try (ZipFile zf = this.newZipFile(this.file);){
            Assert.assertEquals((long)30L, (long)zf.size());
            byte[] buf = new byte[data1.length];
            for (int i = 0; i < 30; ++i) {
                String name = i + ".txt";
                ZipEntry entry = zf.entry(name);
                Assert.assertEquals((long)data1.length, (long)entry.getSize());
                try (InputStream in = zf.getInputStream(name);){
                    int read;
                    int off = 0;
                    do {
                        if ((read = in.read(buf, off, buf.length - off)) < 0) {
                            throw new EOFException();
                        }
                        Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    } while ((off += read) < buf.length);
                    Assert.assertEquals((long)-1L, (long)in.read());
                    Assert.assertTrue((boolean)Arrays.equals(i < 10 ? data1 : data2, buf));
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(int off, int len, byte[] data) throws IOException {
        ZipOutputStream zos;
        if (Files.exists(this.file, new LinkOption[0])) {
            ZipFile zf = this.newZipFile(this.file);
            zf.close();
            zos = this.newZipOutputStream(Files.newOutputStream(this.file, StandardOpenOption.APPEND), zf);
        } else {
            zos = this.newZipOutputStream(Files.newOutputStream(this.file, new OpenOption[0]));
        }
        try {
            for (int i = 0; i < len; ++i) {
                String name = off + i + ".txt";
                zos.putNextEntry(this.newEntry(name));
                zos.write(data);
            }
        }
        finally {
            zos.close();
        }
    }

    static {
        String text = "This is a truly compressible text!\n";
        int count = 1024 / "This is a truly compressible text!\n".length();
        StringBuilder buf = new StringBuilder(count * "This is a truly compressible text!\n".length());
        for (int i = 0; i < count; ++i) {
            buf.append("This is a truly compressible text!\n");
        }
        DATA = buf.toString().getBytes();
    }
}

