/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip.it;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truevfs.comp.zip.WinZipAesParameters;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipFile;
import net.java.truevfs.comp.zip.ZipKeyException;
import net.java.truevfs.comp.zip.ZipOutputStream;
import net.java.truevfs.comp.zip.it.ZipITSuite;
import org.junit.Assert;

public final class WinZipAesIT
extends ZipITSuite {
    @Override
    public ZipEntry newEntry(String name) {
        ZipEntry entry = new ZipEntry(name);
        entry.setEncrypted(true);
        return entry;
    }

    @Override
    protected ZipOutputStream newZipOutputStream(OutputStream out) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        zos.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return zos;
    }

    @Override
    protected ZipOutputStream newZipOutputStream(OutputStream out, Charset charset) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out, charset);
        zos.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return zos;
    }

    @Override
    protected ZipOutputStream newZipOutputStream(OutputStream out, ZipFile appendee) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out, appendee);
        zos.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return zos;
    }

    @Override
    protected ZipFile newZipFile(Path file) throws IOException {
        ZipFile zf = new ZipFile(file);
        zf.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return zf.recoverLostEntries();
    }

    @Override
    protected ZipFile newZipFile(Path file, Charset charset) throws IOException {
        ZipFile zf = new ZipFile(file, charset);
        zf.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return zf.recoverLostEntries();
    }

    @Override
    protected ZipFile newZipFile(SeekableByteChannel file) throws IOException {
        ZipFile zf = new ZipFile(file);
        zf.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return zf.recoverLostEntries();
    }

    @Override
    protected ZipFile newZipFile(SeekableByteChannel file, Charset charset) throws IOException {
        ZipFile zf = new ZipFile(file, charset);
        zf.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return zf.recoverLostEntries();
    }

    @Override
    public void testBadGetCheckedInputStream() {
    }

    private static final class WinZipAesCryptoParameters
    implements WinZipAesParameters {
        private WinZipAesCryptoParameters() {
        }

        public byte[] getWritePassword(String name) throws ZipKeyException {
            return "top secret".getBytes();
        }

        public byte[] getReadPassword(String name, boolean invalid) throws ZipKeyException {
            if (invalid) {
                throw new ZipKeyException("Unknown password.");
            }
            return "top secret".getBytes();
        }

        public AesKeyStrength getKeyStrength(String name) throws ZipKeyException {
            return AesKeyStrength.BITS_128;
        }

        public void setKeyStrength(String name, AesKeyStrength keyStrength) throws ZipKeyException {
            Assert.assertSame((Object)AesKeyStrength.BITS_128, (Object)keyStrength);
        }
    }
}

