/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.util.Arrays;
import net.java.truevfs.comp.zip.DateTimeConverter;
import net.java.truevfs.comp.zip.ZipEntry;
import org.junit.Assert;
import org.junit.Test;

public final class ZipEntryTest {
    private final ZipEntry entry = new ZipEntry("test");

    @Test
    public void testClone() {
        ZipEntry clone = this.entry.clone();
        Assert.assertNotSame((Object)clone, (Object)this.entry);
    }

    @Test
    public void testPlatform() {
        try {
            this.entry.setPlatform(-2);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setPlatform(256);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getPlatform());
        this.entry.setPlatform(0);
        Assert.assertEquals((long)0L, (long)this.entry.getPlatform());
        this.entry.setPlatform(0);
        Assert.assertEquals((long)0L, (long)this.entry.getPlatform());
        this.entry.setPlatform(3);
        Assert.assertEquals((long)3L, (long)this.entry.getPlatform());
        this.entry.setPlatform(255);
        Assert.assertEquals((long)255L, (long)this.entry.getPlatform());
        this.entry.setPlatform(-1);
        Assert.assertEquals((long)-1L, (long)this.entry.getPlatform());
    }

    @Test
    public void testRawPlatform() {
        try {
            this.entry.setRawPlatform(-2);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawPlatform(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawPlatform(256);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getRawPlatform());
        this.entry.setRawPlatform(0);
        Assert.assertEquals((long)0L, (long)this.entry.getRawPlatform());
        this.entry.setRawPlatform(0);
        Assert.assertEquals((long)0L, (long)this.entry.getRawPlatform());
        this.entry.setRawPlatform(3);
        Assert.assertEquals((long)3L, (long)this.entry.getRawPlatform());
        this.entry.setRawPlatform(255);
        Assert.assertEquals((long)255L, (long)this.entry.getRawPlatform());
    }

    @Test
    public void testGeneralPurposeBitFlags() {
        try {
            this.entry.setGeneralPurposeBitFlags(-2);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setGeneralPurposeBitFlags(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setGeneralPurposeBitFlags(65536);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getGeneralPurposeBitFlags());
        this.entry.setGeneralPurposeBitFlags(1);
        Assert.assertEquals((long)1L, (long)this.entry.getGeneralPurposeBitFlags());
        this.entry.setGeneralPurposeBitFlags(8);
        Assert.assertEquals((long)8L, (long)this.entry.getGeneralPurposeBitFlags());
        this.entry.setGeneralPurposeBitFlags(2048);
        Assert.assertEquals((long)2048L, (long)this.entry.getGeneralPurposeBitFlags());
        this.entry.setGeneralPurposeBitFlags(65535);
        Assert.assertEquals((long)65535L, (long)this.entry.getGeneralPurposeBitFlags());
    }

    @Test
    public void testMethod() {
        try {
            this.entry.setMethod(-2);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setMethod(65535);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setMethod(65536);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getMethod());
        this.entry.setMethod(0);
        Assert.assertEquals((long)0L, (long)this.entry.getMethod());
        this.entry.setMethod(8);
        Assert.assertEquals((long)8L, (long)this.entry.getMethod());
        this.entry.setMethod(12);
        Assert.assertEquals((long)12L, (long)this.entry.getMethod());
        this.entry.setMethod(-1);
        Assert.assertEquals((long)-1L, (long)this.entry.getMethod());
    }

    @Test
    public void testRawMethod() {
        try {
            this.entry.setRawMethod(-2);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawMethod(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawMethod(65536);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getRawMethod());
        this.entry.setRawMethod(0);
        Assert.assertEquals((long)0L, (long)this.entry.getRawMethod());
        this.entry.setRawMethod(0);
        Assert.assertEquals((long)0L, (long)this.entry.getRawMethod());
        this.entry.setRawMethod(8);
        Assert.assertEquals((long)8L, (long)this.entry.getRawMethod());
        this.entry.setRawMethod(65535);
        Assert.assertEquals((long)65535L, (long)this.entry.getRawMethod());
    }

    @Test
    public void testRoundTripTimeConversion() {
        long dosTime = 0x210000L;
        Assert.assertEquals((long)dosTime, (long)DateTimeConverter.JAR.toDosTime(DateTimeConverter.JAR.toJavaTime(dosTime)));
        dosTime = DateTimeConverter.JAR.toDosTime(System.currentTimeMillis());
        Assert.assertEquals((long)dosTime, (long)DateTimeConverter.JAR.toDosTime(DateTimeConverter.JAR.toJavaTime(dosTime)));
    }

    @Test
    public void testTime() {
        try {
            this.entry.setTime(Long.MIN_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setTime(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getTime());
        this.entry.setTime(0L);
        Assert.assertEquals((long)this.entry.getTime(), (long)DateTimeConverter.JAR.toJavaTime(0x210000L));
        this.entry.setTime(Long.MAX_VALUE);
        Assert.assertEquals((long)this.entry.getTime(), (long)DateTimeConverter.JAR.toJavaTime(4288659325L));
        this.entry.setTime(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getTime());
    }

    @Test
    public void testRawTime() {
        try {
            this.entry.setRawTime(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawTime(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawTime(0x100000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getRawTime());
        this.entry.setRawTime(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getRawTime());
        this.entry.setRawTime(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawTime());
    }

    @Test
    public void testCrc() {
        try {
            this.entry.setCrc(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setCrc(0x100000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getCrc());
        this.entry.setCrc(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getCrc());
        this.entry.setCrc(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getCrc());
        this.entry.setCrc(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getCrc());
    }

    @Test
    public void testRawCrc() {
        try {
            this.entry.setRawCrc(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawCrc(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawCrc(0x100000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getRawCrc());
        this.entry.setRawCrc(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getRawCrc());
        this.entry.setRawCrc(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawCrc());
    }

    @Test
    public void testCompressedSize() {
        try {
            this.entry.setCompressedSize(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setCompressedSize(Long.MIN_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(0x100000000L);
        Assert.assertEquals((long)0x100000000L, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getCompressedSize());
    }

    @Test
    public void testRawCompressedSize() {
        try {
            this.entry.setRawCompressedSize(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawCompressedSize(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawCompressedSize(Long.MIN_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getRawCompressedSize());
        this.entry.setRawCompressedSize(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getRawCompressedSize());
        this.entry.setRawCompressedSize(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawCompressedSize());
        this.entry.setRawCompressedSize(0x100000000L);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawCompressedSize());
    }

    @Test
    public void testSize() {
        try {
            this.entry.setSize(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setSize(Long.MIN_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getSize());
        this.entry.setSize(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getSize());
        this.entry.setSize(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getSize());
        this.entry.setSize(0x100000000L);
        Assert.assertEquals((long)0x100000000L, (long)this.entry.getSize());
        this.entry.setSize(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getSize());
    }

    @Test
    public void testRawSize() {
        try {
            this.entry.setRawSize(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawSize(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawSize(Long.MIN_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getRawSize());
        this.entry.setRawSize(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getRawSize());
        this.entry.setRawSize(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawSize());
        this.entry.setRawSize(0x100000000L);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawSize());
    }

    @Test
    public void testExternalAttributes() {
        try {
            this.entry.setExternalAttributes(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setExternalAttributes(0x100000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getExternalAttributes());
        this.entry.setExternalAttributes(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getExternalAttributes());
        this.entry.setExternalAttributes(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getExternalAttributes());
        this.entry.setExternalAttributes(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getExternalAttributes());
    }

    @Test
    public void testRawExternalAttributes() {
        try {
            this.entry.setRawExternalAttributes(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawExternalAttributes(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawExternalAttributes(0x100000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.entry.getRawExternalAttributes());
        this.entry.setRawExternalAttributes(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getRawExternalAttributes());
        this.entry.setRawExternalAttributes(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawExternalAttributes());
    }

    @Test
    public void testRawOffset() {
        try {
            this.entry.setRawOffset(-2L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawOffset(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.entry.setRawOffset(Long.MIN_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getOffset());
        Assert.assertEquals((long)0L, (long)this.entry.getRawOffset());
        this.entry.setRawOffset(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getOffset());
        Assert.assertEquals((long)0L, (long)this.entry.getRawOffset());
        this.entry.setRawOffset(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getOffset());
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawOffset());
        this.entry.setRawOffset(0x100000000L);
        Assert.assertEquals((long)0x100000000L, (long)this.entry.getOffset());
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawOffset());
    }

    @Test
    public void testExtra() {
        Assert.assertEquals((long)0L, (long)this.entry.getExtra().length);
        byte[] set = new byte[]{0, 0, 0, 0, 1, 0, 24, 0, 33, 67, 101, -121, -87, -53, -19, 15, 34, 67, 101, -121, -87, -53, -19, 15, 35, 67, 101, -121, -87, -53, -19, 15, -2, -54, 0, 0};
        this.entry.setRawSize(0xFFFFFFFFL);
        this.entry.setRawCompressedSize(0xFFFFFFFFL);
        this.entry.setRawOffset(0xFFFFFFFFL);
        this.entry.setRawExtraFields(set);
        Assert.assertEquals((long)1147797409030816545L, (long)this.entry.getSize());
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawSize());
        Assert.assertEquals((long)1147797409030816546L, (long)this.entry.getCompressedSize());
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawCompressedSize());
        Assert.assertEquals((long)1147797409030816547L, (long)this.entry.getOffset());
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getRawOffset());
        set[0] = -1;
        byte[] got1 = this.entry.getRawExtraFields();
        Assert.assertNotNull((Object)got1);
        Assert.assertNotSame((Object)set, (Object)got1);
        byte[] got2 = this.entry.getRawExtraFields();
        Assert.assertNotNull((Object)got2);
        Assert.assertNotSame((Object)set, (Object)got2);
        Assert.assertNotSame((Object)got1, (Object)got2);
        set[0] = 0;
        Assert.assertTrue((boolean)Arrays.equals(set, got1));
        Assert.assertTrue((boolean)Arrays.equals(set, got2));
    }
}

