/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import net.java.truecommons.io.ByteBufferChannel;
import net.java.truecommons.io.ChannelOutputStream;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipFile;
import net.java.truevfs.comp.zip.ZipOutputStream;
import org.junit.Assert;
import org.junit.Test;

public final class ManySmallEntriesTest {
    private static final int FIRST_ENTRY = 100000;
    private static final int LAST_ENTRY = 169999;
    private static final int NUM_ENTRIES = 70000;
    private static final String DATA_STRING = "Hello World!";
    private static final Charset DATA_CHARSET = Charset.forName("US-ASCII");
    private static final int DATA_CRC = 472456355;
    private static final int ZIP_SIZE = 7000098;

    @Test
    public void testRoundTripPersistence() throws IOException {
        ZipEntry entry;
        byte[] data = DATA_STRING.getBytes(DATA_CHARSET);
        ByteBuffer bb = ByteBuffer.allocateDirect(7000098);
        HashSet<String> set = new HashSet<String>(HashMaps.initialCapacity((int)70000));
        ByteBufferChannel bbc = new ByteBufferChannel(bb);
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)new ChannelOutputStream((WritableByteChannel)bbc));){
            for (int i = 100000; i <= 169999; ++i) {
                String name = Integer.toString(i);
                entry = new ZipEntry(name);
                entry.setSize((long)data.length);
                entry.setCompressedSize((long)data.length);
                entry.setCrc(472456355L);
                entry.setMethod(0);
                zos.putNextEntry(entry);
                zos.write(data);
                Assert.assertTrue((boolean)set.add(name));
            }
        }
        bb = bbc.getBuffer();
        bb.flip();
        Assert.assertEquals((long)7000098L, (long)bb.limit());
        var6_6 = null;
        try (ZipFile zf = new ZipFile((SeekableByteChannel)new ByteBufferChannel(bb));){
            byte[] buf = new byte[data.length];
            Enumeration e = zf.entries();
            while (e.hasMoreElements()) {
                entry = (ZipEntry)e.nextElement();
                String name = entry.getName();
                Assert.assertEquals((long)data.length, (long)entry.getSize());
                try (InputStream in = zf.getCheckedInputStream(name);){
                    int read;
                    int off = 0;
                    while ((read = in.read(buf)) >= 0) {
                        Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                        Assert.assertEquals((Object)ByteBuffer.wrap(data, off, read), (Object)ByteBuffer.wrap(buf, 0, read));
                        off += read;
                    }
                    Assert.assertEquals((long)-1L, (long)read);
                    Assert.assertEquals((long)off, (long)data.length);
                    Assert.assertEquals((long)0L, (long)in.read(new byte[0]));
                }
                Assert.assertTrue((boolean)set.remove(name));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        Assert.assertTrue((boolean)set.isEmpty());
    }
}

